/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import juzu.io.AppendableStream;
import juzu.io.BinaryOutputStream;
import juzu.io.Stream;
import juzu.io.Streamable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Streams {
    public static Stream empty() {
        return new Stream(){

            public Stream append(ByteBuffer buffer) throws IOException {
                return this;
            }

            public Stream append(CharBuffer buffer) throws IOException {
                return this;
            }

            public Stream append(CharSequence csq) throws IOException {
                return this;
            }

            public Stream append(CharSequence csq, int start, int end) throws IOException {
                return this;
            }

            public Stream append(char c) throws IOException {
                return this;
            }

            public Stream append(byte[] data) throws IOException {
                return this;
            }

            public Stream append(byte[] data, int off, int len) throws IOException {
                return this;
            }

            public void close() throws IOException {
            }

            public void flush() throws IOException {
            }
        };
    }

    public static Streamable streamable(final Readable readable) {
        return new Streamable(){

            public void send(Stream stream) throws IOException {
                CharBuffer buffer = CharBuffer.allocate(512);
                int i = readable.read(buffer);
                while (i != -1) {
                    buffer.flip();
                    stream.append(buffer);
                    buffer.clear();
                    i = readable.read(buffer);
                }
                if (readable instanceof Closeable) {
                    ((Closeable)((Object)readable)).close();
                }
            }
        };
    }

    public static Stream appendable(Charset charset, Appendable appendable) {
        return new AppendableStream(charset, appendable);
    }

    public static <A extends Appendable & Flushable> Stream flushable(Charset charset, A appendable) {
        return new AppendableStream(charset, appendable, appendable, null);
    }

    public static <A extends Appendable & Flushable> Stream closeable(Charset charset, A appendable) {
        return new AppendableStream(charset, appendable, appendable, (Closeable)appendable);
    }

    public static <A extends OutputStream & Closeable> Stream closeable(Charset charset, A appendable) {
        return new BinaryOutputStream(charset, appendable);
    }
}

