/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;
import juzu.PropertyType;
import juzu.impl.bridge.spi.web.AsyncStream;
import juzu.impl.bridge.spi.web.WebRequestContext;
import juzu.io.Chunk;
import juzu.io.Stream;

public abstract class HttpStream
implements AsyncStream {
    private static final int STATUS_BUFFERING = 0;
    private static final int STATUS_STREAMING = 1;
    private static final int STATUS_CLOSED = 2;
    protected Charset encoding;
    protected String mimeType;
    protected LinkedList<Map.Entry<String, String[]>> headers;
    private int status;
    private final WebRequestContext context;

    public HttpStream(WebRequestContext context, int statusCode, Charset encoding) {
        this.context = context;
        this.status = 0;
        this.headers = new LinkedList();
        this.mimeType = null;
        this.encoding = encoding;
        this.setStatusCode(statusCode);
    }

    public abstract void setStatusCode(int var1);

    public void provide(Chunk chunk) {
        if (this.status == 0) {
            if (chunk instanceof Chunk.Property) {
                Chunk.Property property = (Chunk.Property)chunk;
                if (property.type == PropertyType.ENCODING) {
                    this.encoding = (Charset)property.value;
                } else if (property.type == PropertyType.MIME_TYPE) {
                    this.mimeType = (String)property.value;
                } else if (property.type == PropertyType.HEADER) {
                    this.headers.addLast((Map.Entry)property.value);
                }
            } else if (chunk instanceof Chunk.Data) {
                this.sendHeaders();
                this.status = 1;
            }
        }
        if (this.status == 1 && chunk instanceof Chunk.Data) {
            this.getDataStream(true).provide(chunk);
        }
    }

    protected abstract Stream getDataStream(boolean var1);

    private void sendHeaders() {
        if (this.mimeType != null) {
            this.context.setContentType(this.mimeType, this.encoding);
        }
        this.context.setHeaders(this.headers);
    }

    public void close(Thread.UncaughtExceptionHandler errorHandler) {
        if (this.status == 0) {
            this.sendHeaders();
        }
        if (this.status != 2) {
            this.status = 2;
            Stream dataStream = this.getDataStream(false);
            if (dataStream != null) {
                dataStream.close(errorHandler);
            }
            this.endAsync();
        }
    }

    public void end() {
        if (this.status != 2) {
            this.beginAsync();
        }
    }

    protected abstract void endAsync();

    protected abstract void beginAsync();
}

