/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi;

import java.io.Serializable;
import java.util.Map;
import juzu.impl.common.Content;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Path;
import juzu.impl.common.Resource;
import juzu.impl.common.Timestamped;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.template.spi.ParseContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.TemplateException;
import juzu.impl.template.spi.TemplateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessContext {
    public abstract Resource<Timestamped<Content>> resolveResource(Path.Relative var1);

    public abstract MethodInvocation resolveMethodInvocation(String var1, String var2, Map<String, String> var3) throws ProcessingException;

    protected abstract TemplateProvider resolverProvider(String var1);

    protected abstract <M extends Serializable> Template<M> getTemplate(Path.Relative var1);

    protected abstract <M extends Serializable> void registerTemplate(Template<M> var1);

    protected abstract <M extends Serializable> void register(Path.Relative var1, Template<M> var2);

    public Template resolveTemplate(Path.Relative path) {
        return this.resolveTemplate(null, path);
    }

    public <M extends Serializable> Template<? extends M> resolveTemplate(Path.Relative originPath, Path.Relative path) {
        Template<M> template = this.getTemplate(path);
        if (template == null) {
            Object templateAST;
            Resource<Timestamped<Content>> resolved = this.resolveResource(path);
            if (resolved == null) {
                throw TemplateMetaModel.TEMPLATE_NOT_RESOLVED.failure(path);
            }
            TemplateProvider provider = this.resolverProvider(path.getExt());
            try {
                templateAST = provider.parse(new ParseContext(), ((Content)((Timestamped)resolved.content).getObject()).getCharSequence());
            }
            catch (TemplateException e) {
                throw TemplateMetaModel.TEMPLATE_SYNTAX_ERROR.failure(path);
            }
            template = new Template(templateAST, path, resolved.path, ((Timestamped)resolved.content).getTime());
            this.registerTemplate(template);
            try {
                provider.process(this, template);
            }
            catch (TemplateException e) {
                throw TemplateMetaModel.TEMPLATE_VALIDATION_ERROR.failure(path);
            }
        }
        this.register(originPath, template);
        return template;
    }
}

