/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import juzu.impl.common.Path;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.template.metadata.TemplateDescriptor;
import juzu.impl.plugin.template.metadata.TemplatesDescriptor;
import juzu.impl.template.spi.TemplateStub;

public class TemplatePlugin
extends ApplicationPlugin {
    private TemplatesDescriptor descriptor;
    private final ConcurrentHashMap<Path, TemplateStub> stubs = new ConcurrentHashMap();
    private PluginContext context;

    public TemplatePlugin() {
        super("template");
    }

    public TemplatesDescriptor getDescriptor() {
        return this.descriptor;
    }

    public PluginDescriptor init(PluginContext context) throws Exception {
        this.context = context;
        this.descriptor = new TemplatesDescriptor(this.application, context.getClassLoader(), context.getConfig());
        return this.descriptor;
    }

    public TemplateStub resolveTemplateStub(String path) {
        return this.resolveTemplateStub(Path.parse(path));
    }

    public TemplateStub resolveTemplateStub(Path path) {
        TemplateStub stub = this.stubs.get(path);
        if (stub == null) {
            TemplateDescriptor desc;
            Path.Absolute resolved = this.descriptor.getPackage().resolve(path);
            try {
                Class<?> clazz = this.context.getClassLoader().loadClass(resolved.getName().toString());
                Field f = clazz.getField("DESCRIPTOR");
                desc = (TemplateDescriptor)f.get(null);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Handle me gracefully", e);
            }
            stub = desc.getStub();
            TemplateStub phantom = this.stubs.putIfAbsent(path, stub);
            if (phantom != null) {
                stub = phantom;
            } else {
                stub.init();
            }
        }
        return stub;
    }
}

