/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import juzu.asset.AssetLocation;
import juzu.impl.asset.Asset;
import juzu.impl.asset.AssetNode;
import juzu.impl.common.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetManager {
    protected final LinkedHashMap<String, AssetNode> assets = new LinkedHashMap();
    protected final HashMap<String, URL> resources = new HashMap();

    public boolean addAsset(String id, AssetLocation location, String value, URL url, String ... dependencies) throws NullPointerException, IllegalArgumentException {
        return this.addAsset(id, location, Collections.singletonMap(value, url), Tools.set(dependencies));
    }

    public boolean addAsset(String id, AssetLocation location, Map<String, URL> resources, Set<String> dependencies) throws NullPointerException, IllegalArgumentException {
        if (!this.assets.keySet().contains(id)) {
            AssetNode asset = new AssetNode(id, location, new HashSet<String>(resources.keySet()), dependencies);
            for (AssetNode assetNode : this.assets.values()) {
                if (assetNode.iDependOn.contains(id)) {
                    asset.dependsOnMe = Tools.addToHashSet(asset.dependsOnMe, assetNode.id);
                }
                if (!asset.iDependOn.contains(assetNode.id)) continue;
                assetNode.dependsOnMe = Tools.addToHashSet(assetNode.dependsOnMe, id);
            }
            this.assets.put(id, asset);
            for (Map.Entry entry : resources.entrySet()) {
                if (entry.getValue() == null) continue;
                this.resources.put((String)entry.getKey(), (URL)entry.getValue());
            }
            return true;
        }
        return false;
    }

    public URL resolveAsset(String path) {
        return this.resources.get(path);
    }

    public Iterable<Asset> resolveAssets(Iterable<String> ids) throws NullPointerException, IllegalArgumentException {
        LinkedHashMap<String, HashSet<String>> sub = new LinkedHashMap<String, HashSet<String>>();
        LinkedList<String> queue = Tools.addAll(new LinkedList(), ids);
        while (!queue.isEmpty()) {
            String id = (String)queue.removeFirst();
            AssetNode asset = this.assets.get(id);
            if (asset != null) {
                sub.put(asset.id, new HashSet<String>(asset.iDependOn));
                for (String string : asset.iDependOn) {
                    if (sub.containsKey(string)) continue;
                    queue.addLast(string);
                }
                continue;
            }
            throw new IllegalArgumentException("Cannot resolve asset " + id);
        }
        LinkedList<Asset> resolved = new LinkedList<Asset>();
        while (sub.size() > 0) {
            boolean found = false;
            Iterator i = sub.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!((HashSet)entry.getValue()).isEmpty()) continue;
                i.remove();
                AssetNode assetNode = this.assets.get(entry.getKey());
                for (String value : assetNode.value) {
                    resolved.addLast(Asset.of(assetNode.getLocation(), value));
                }
                for (String dependency : assetNode.dependsOnMe) {
                    HashSet foo = (HashSet)sub.get(dependency);
                    if (foo == null) continue;
                    foo.remove(entry.getKey());
                }
                found = true;
                break;
            }
            if (found) continue;
            StringBuilder sb = new StringBuilder("Cannot satisfy asset dependencies:\n");
            for (Map.Entry entry : sub.entrySet()) {
                sb.append((String)entry.getKey()).append(" -> ").append(entry.getValue());
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return resolved;
    }
}

