/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi;

import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.cdi.provided.ProvidedCDIInjector;
import juzu.impl.inject.spi.cdi.weld.WeldInjector;
import juzu.impl.inject.spi.guice.GuiceInjector;
import juzu.impl.inject.spi.spring.SpringInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InjectorProvider {
    CDI_WELD("weld"){

        public Injector get() {
            try {
                Object manager = new InitialContext().lookup("java:comp/BeanManager");
                return ProvidedCDIInjector.get(manager);
            }
            catch (NamingException namingException) {
                return new WeldInjector();
            }
        }
    }
    ,
    INJECT_GUICE("guice"){

        public Injector get() {
            return new GuiceInjector();
        }
    }
    ,
    INJECT_SPRING("spring"){

        public Injector get() {
            return new SpringInjector();
        }
    };

    final String value;
    private static final Map<String, InjectorProvider> LOOKUP;

    public abstract Injector get();

    private InjectorProvider(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static InjectorProvider find(String value) {
        if ("guice".equals(value)) {
            return INJECT_GUICE;
        }
        if ("spring".equals(value)) {
            return INJECT_SPRING;
        }
        if ("weld".equals(value)) {
            return CDI_WELD;
        }
        return null;
    }

    static {
        LOOKUP = new HashMap<String, InjectorProvider>();
        for (InjectorProvider injectorProvider : InjectorProvider.values()) {
            LOOKUP.put(injectorProvider.getValue(), injectorProvider);
        }
    }
}

