/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.vertx;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.Cookie;
import juzu.Method;
import juzu.asset.AssetLocation;
import juzu.bridge.vertx.Application;
import juzu.bridge.vertx.VertxStream;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.common.Lexers;
import juzu.impl.common.Logger;
import juzu.impl.inject.ScopedContext;
import juzu.io.Stream;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.RequestParameter;
import juzu.request.UserContext;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertxWebBridge
extends WebBridge
implements HttpContext {
    private static final ApplicationContext APPLICATION_CONTEXT = new ApplicationContext(){

        public ResourceBundle resolveBundle(Locale locale) {
            return null;
        }
    };
    private final Application application;
    private final Logger log;
    private ScopedContext requestScope;
    private final HttpServerRequest req;
    private Stream writer;
    private Map<String, RequestParameter> parameters;
    private Buffer buffer;
    private final Method method;
    private final Bridge bridge;

    public VertxWebBridge(Bridge bridge, Application application, HttpServerRequest req, Buffer buffer, Logger log) {
        this.application = application;
        this.requestScope = null;
        this.req = req;
        this.writer = null;
        this.log = log;
        this.parameters = null;
        this.buffer = buffer;
        this.method = Method.valueOf((String)req.method);
        this.bridge = bridge;
    }

    void handle(Handler handler) {
        try {
            handler.handle((WebBridge)this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.req.response.statusCode = 500;
            this.req.response.end();
            this.req.response.close();
        }
    }

    protected void end() {
        this.req.response.end();
        this.req.response.close();
    }

    public Map<String, RequestParameter> getParameters() {
        if (this.parameters == null) {
            if (this.req.query != null) {
                this.parameters = Lexers.parseQuery((String)this.req.query);
            } else {
                HashMap hashMap = this.parameters = this.buffer != null ? new HashMap() : Collections.emptyMap();
            }
            if (this.buffer != null) {
                Iterator i = Lexers.queryParser((CharSequence)this.buffer.toString());
                while (i.hasNext()) {
                    RequestParameter parameter = (RequestParameter)i.next();
                    parameter.appendTo(this.parameters);
                }
            }
        }
        return this.parameters;
    }

    public String getRequestURI() {
        return "/";
    }

    public String getPath() {
        return "/";
    }

    public String getRequestPath() {
        return this.req.path;
    }

    public void renderRequestURL(Appendable appendable) throws IOException {
        appendable.append("http://localhost:8080");
    }

    public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws IOException {
        switch (location) {
            case APPLICATION: {
                if (!uri.startsWith("/")) {
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case URL: {
                appendable.append(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException("todo");
            }
        }
    }

    public ScopedContext getRequestScope(boolean create) {
        if (this.requestScope == null && create) {
            this.requestScope = new ScopedContext(this.log);
        }
        return this.requestScope;
    }

    public ScopedContext getFlashScope(boolean create) {
        if (create) {
            throw new UnsupportedOperationException("todo");
        }
        return null;
    }

    public ScopedContext getSessionScope(boolean create) {
        if (create) {
            throw new UnsupportedOperationException("todo");
        }
        return null;
    }

    public void purgeSession() {
        throw new UnsupportedOperationException("todo");
    }

    public HttpContext getHttpContext() {
        return this;
    }

    public ClientContext getClientContext() {
        throw new UnsupportedOperationException("todo");
    }

    public ApplicationContext getApplicationContext() {
        return APPLICATION_CONTEXT;
    }

    public void setContentType(String mimeType, Charset charset) {
        this.req.response.headers().put("Content-Type", "text/html; charset=UTF-8");
    }

    public void setStatus(int status) {
        this.req.response.statusCode = status;
    }

    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException("todo");
    }

    public void sendRedirect(String location) throws IOException {
        switch (this.method) {
            case GET: 
            case HEAD: {
                this.setStatus(302);
                break;
            }
            default: {
                this.setStatus(303);
            }
        }
        this.req.response.headers().put("Location", location);
        this.req.response.end();
        this.req.response.close();
    }

    public Stream getStream(Charset charset) throws IOException {
        if (this.writer == null) {
            this.writer = new VertxStream(charset, this.req.response);
        }
        return this.writer;
    }

    public UserContext getUserContext() {
        throw new UnsupportedOperationException();
    }

    public Method getMethod() {
        return this.method;
    }

    public Cookie[] getCookies() {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "http";
    }

    public int getServerPort() {
        return this.application.port;
    }

    public String getServerName() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return "/";
    }
}

