/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.ram;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import juzu.impl.common.Content;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.ram.RAMDir;
import juzu.impl.fs.spi.ram.RAMFile;
import juzu.impl.fs.spi.ram.RAMPath;
import juzu.impl.fs.spi.ram.RAMURLStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMFileSystem
extends ReadWriteFileSystem<String[]> {
    private final RAMDir root;
    private final URL contextURL;

    public RAMFileSystem() {
        try {
            this.root = new RAMDir(this);
            this.contextURL = new URL("juzu", null, 0, "/", new RAMURLStreamHandler(this));
        }
        catch (MalformedURLException e) {
            AssertionError ae = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    @Override
    public Class<String[]> getType() {
        return String[].class;
    }

    @Override
    public String getDescription() {
        return "ram[]";
    }

    @Override
    public String[] makePath(String[] parent, String name) throws IOException {
        String[] path = Arrays.copyOf(parent, parent.length + 1);
        path[path.length - 1] = name;
        return path;
    }

    private RAMPath get(String[] path) {
        RAMPath current = this.root;
        for (String name : path) {
            if (!(current instanceof RAMDir)) {
                return null;
            }
            current = current.children.get(name);
        }
        return current;
    }

    @Override
    public void createDir(String[] dir) throws IOException {
        long lastModified = System.currentTimeMillis();
        RAMDir current = this.root;
        for (String name : dir) {
            RAMPath next = current.children.get(name);
            if (next == null) {
                next = new RAMDir(current, name, lastModified);
                current.children.put(name, next);
                next.parent = current;
                current = (RAMDir)next;
                continue;
            }
            if (next instanceof RAMDir) {
                current = (RAMDir)next;
                continue;
            }
            throw new IOException("A file already exist");
        }
    }

    @Override
    public long setContent(String[] file, Content content) throws IOException {
        long lastModified = System.currentTimeMillis();
        RAMDir current = this.root;
        for (int i = 0; i < file.length; ++i) {
            String name = file[i];
            RAMPath next = current.children.get(name);
            if (i == file.length - 1) {
                if (next == null) {
                    next = new RAMFile(current, name, content);
                    current.children.put(name, next);
                    next.parent = current;
                } else if (next instanceof RAMFile) {
                    ((RAMFile)next).content = new Timestamped<Content>(lastModified, content);
                } else {
                    throw new IOException("A file already exist");
                }
                return next.getLastModified();
            }
            if (next == null) {
                next = new RAMDir(current, name, lastModified);
                current.children.put(name, next);
                next.parent = current;
                current = (RAMDir)next;
                continue;
            }
            if (next instanceof RAMDir) {
                current = (RAMDir)next;
                continue;
            }
            throw new IOException("A file already exist");
        }
        throw new IOException();
    }

    @Override
    public Timestamped<Content> getContent(String[] file) throws IOException {
        if (file == null) {
            throw new NullPointerException("No null file argument accepted");
        }
        RAMPath path = this.get(file);
        return path instanceof RAMFile ? ((RAMFile)path).content : null;
    }

    @Override
    public boolean equals(String[] left, String[] right) {
        return Arrays.equals(left, right);
    }

    @Override
    public String getName(String[] path) {
        return path.length > 0 ? path[path.length - 1] : "";
    }

    @Override
    public Iterator<String[]> getChildren(String[] dir) throws IOException {
        RAMPath path = this.get(dir);
        if (path instanceof RAMDir) {
            RAMDir a = (RAMDir)path;
            ArrayList<String[]> children = new ArrayList<String[]>(a.children.size());
            for (RAMPath child : a.children.values()) {
                children.add(child.names);
            }
            return children.iterator();
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public String[] getChild(String[] dir, String name) throws IOException {
        RAMPath path = this.get(dir);
        if (path instanceof RAMDir) {
            RAMPath child = ((RAMDir)path).children.get(name);
            return child != null ? child.names : null;
        }
        return null;
    }

    @Override
    public PathType typeOf(String[] path) throws IOException {
        RAMPath foo = this.get(path);
        if (foo instanceof RAMDir) {
            return PathType.DIR;
        }
        if (foo instanceof RAMFile) {
            return PathType.FILE;
        }
        return null;
    }

    @Override
    public long getLastModified(String[] path) throws IOException {
        RAMPath foo = this.get(path);
        return foo != null ? foo.getLastModified() : 0L;
    }

    @Override
    public File getFile(String[] path) {
        return null;
    }

    @Override
    public URL getURL(String[] path) throws NullPointerException, IOException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        return new URL(this.contextURL, Tools.join('/', path));
    }

    @Override
    public boolean removePath(String[] path) throws IOException {
        RAMPath foo = this.get(path);
        if (foo != null) {
            foo.parent.children.remove(foo.name);
            foo.parent = null;
        }
        return true;
    }

    @Override
    public String[] getRoot() throws IOException {
        return this.root.names;
    }
}

