/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import juzu.Response;
import juzu.Scope;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.DispatchBridge;
import juzu.impl.bridge.spi.EventBridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopingContext;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.Method;
import juzu.impl.request.RequestFilter;
import juzu.request.ActionContext;
import juzu.request.Dispatch;
import juzu.request.EventContext;
import juzu.request.Phase;
import juzu.request.RenderContext;
import juzu.request.RequestContext;
import juzu.request.RequestLifeCycle;
import juzu.request.RequestParameter;
import juzu.request.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
implements ScopingContext {
    private static final ThreadLocal<Request> current = new ThreadLocal();
    private final ControllerPlugin plugin;
    private final RequestBridge bridge;
    private final RequestContext context;
    private final Map<String, RequestParameter> parameters;
    private final Map<ControlParameter, Object> arguments;
    private Response response;
    private int index = 0;

    public static Request getCurrent() {
        return current.get();
    }

    public Request(ControllerPlugin plugin, Method method, Map<String, RequestParameter> parameters, RequestBridge bridge) {
        HashMap<ControlParameter, Object> arguments = new HashMap<ControlParameter, Object>(bridge.getArguments());
        RequestContext context = bridge instanceof RenderBridge ? new RenderContext(this, method, (RenderBridge)bridge) : (bridge instanceof ActionBridge ? new ActionContext(this, method, (ActionBridge)bridge) : (bridge instanceof EventBridge ? new EventContext(this, method, (EventBridge)bridge) : new ResourceContext(this, method, (ResourceBridge)bridge)));
        this.context = context;
        this.bridge = bridge;
        this.parameters = parameters;
        this.arguments = arguments;
        this.plugin = plugin;
    }

    public RequestBridge getBridge() {
        return this.bridge;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Map<String, RequestParameter> getParameters() {
        return this.parameters;
    }

    public RequestContext getContext() {
        return this.context;
    }

    public Map<ControlParameter, Object> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<ControlParameter, Object> arguments) {
        this.arguments.clear();
        this.arguments.putAll(arguments);
    }

    public void setArgument(ControlParameter parameter, Object value) {
        this.arguments.put(parameter, value);
    }

    @Override
    public final Scoped getContextualValue(Scope scope, Object key) {
        switch (scope) {
            case FLASH: {
                return this.bridge.getFlashValue(key);
            }
            case REQUEST: {
                return this.bridge.getRequestValue(key);
            }
            case SESSION: {
                return this.bridge.getSessionValue(key);
            }
            case IDENTITY: {
                return this.bridge.getIdentityValue(key);
            }
        }
        throw new AssertionError();
    }

    @Override
    public final void setContextualValue(Scope scope, Object key, Scoped value) {
        switch (scope) {
            case FLASH: {
                this.bridge.setFlashValue(key, value);
                break;
            }
            case REQUEST: {
                this.bridge.setRequestValue(key, value);
                break;
            }
            case SESSION: {
                this.bridge.setSessionValue(key, value);
                break;
            }
            case IDENTITY: {
                this.bridge.setIdentityValue(key, value);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean isActive(Scope scope) {
        switch (scope) {
            case IDENTITY: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        block11: {
            boolean set = current.get() == null;
            try {
                if (set) {
                    current.set(this);
                }
                List<RequestFilter> filters = this.plugin.getFilters();
                if (this.index >= 0 && this.index < filters.size()) {
                    RequestFilter plugin = filters.get(this.index);
                    try {
                        ++this.index;
                        plugin.invoke(this);
                        break block11;
                    }
                    finally {
                        --this.index;
                    }
                }
                if (this.index == filters.size()) {
                    Method method = this.context.getMethod();
                    Object[] args = new Object[method.getParameters().size()];
                    for (int i = 0; i < args.length; ++i) {
                        ControlParameter parameter = method.getParameters().get(i);
                        args[i] = this.arguments.get(parameter);
                    }
                    Request.doInvoke(this, args, this.plugin.getInjectionContext());
                    break block11;
                }
                throw new AssertionError();
            }
            finally {
                if (set) {
                    current.set(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <B, I> void doInvoke(Request request, Object[] args, InjectionContext<B, I> manager) {
        block16: {
            RequestContext context = request.getContext();
            Class<?> type = context.getMethod().getType();
            BeanLifeCycle<?> lifeCycle = manager.get(type);
            if (lifeCycle != null) {
                try {
                    Object controller;
                    try {
                        controller = lifeCycle.get();
                    }
                    catch (InvocationTargetException e) {
                        request.response = Response.error(e.getCause());
                        controller = null;
                    }
                    if (controller == null) break block16;
                    if (controller instanceof RequestLifeCycle) {
                        try {
                            ((RequestLifeCycle)controller).beginRequest(context);
                        }
                        catch (Exception e) {
                            request.response = new Response.Error(e);
                        }
                    }
                    if (request.getResponse() != null) break block16;
                    try {
                        Object ret = context.getMethod().getMethod().invoke(controller, args);
                        if (ret instanceof Response) {
                            request.response = (Response)ret;
                        }
                    }
                    catch (InvocationTargetException e) {
                        request.response = Response.error(e.getCause());
                    }
                    catch (IllegalAccessException e) {
                        throw new UnsupportedOperationException("hanle me gracefully", e);
                    }
                    if (controller instanceof RequestLifeCycle) {
                        try {
                            ((RequestLifeCycle)controller).endRequest(context);
                        }
                        catch (Exception e) {
                            request.response = Response.error(e);
                        }
                    }
                }
                finally {
                    lifeCycle.close();
                }
            }
        }
    }

    public Dispatch createDispatch(Method<?> method, DispatchBridge spi) {
        Dispatch dispatch;
        ControllersDescriptor desc = this.plugin.getDescriptor();
        if (method.getPhase() == Phase.ACTION) {
            dispatch = new Phase.Action.Dispatch(spi);
        } else if (method.getPhase() == Phase.VIEW) {
            dispatch = new Phase.View.Dispatch(spi);
            dispatch.escapeXML(desc.getEscapeXML());
        } else if (method.getPhase() == Phase.RESOURCE) {
            dispatch = new Phase.Resource.Dispatch(spi);
            dispatch.escapeXML(desc.getEscapeXML());
        } else {
            throw new AssertionError();
        }
        dispatch.escapeXML(desc.getEscapeXML());
        return dispatch;
    }
}

