/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.compiler;

import java.util.List;
import juzu.impl.common.Location;
import juzu.impl.common.MethodInvocation;
import juzu.impl.template.spi.EmitContext;
import juzu.impl.template.spi.juzu.DialectTemplateEmitter;
import juzu.impl.template.spi.juzu.ast.ASTNode;
import juzu.impl.template.spi.juzu.compiler.CompilationPhase;
import juzu.impl.template.spi.juzu.compiler.EmitterContext;
import juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmitPhase
extends CompilationPhase {
    private final EmitContext context;

    public EmitPhase(EmitContext context) {
        this.context = context;
    }

    public void emit(DialectTemplateEmitter generator, ASTNode<?> node) {
        this.doAttribute(node);
        EmitterContext ctx = new EmitterContext(generator);
        ctx.open();
        this.doEmit(ctx, node.getChildren());
        ctx.close();
        this.doUnattribute(node);
    }

    private void doEmit(EmitterContext ctx, List<ASTNode.Block<?>> blocks) {
        for (ASTNode.Block<?> block : blocks) {
            if (block instanceof ASTNode.Section) {
                String chunk;
                int to;
                ASTNode.Section section = (ASTNode.Section)block;
                ctx.openSection(section.getType(), section.getBeginPosition());
                int lineNumber = section.getBegin().getPosition().getLine();
                int colNumber = section.getBegin().getPosition().getCol();
                String text = section.getText();
                int from = 0;
                while ((to = text.indexOf(10, from)) != -1) {
                    chunk = text.substring(from, to);
                    ctx.appendText(chunk);
                    ctx.appendLineBreak(new Location(colNumber + (to - from), lineNumber));
                    from = to + 1;
                    ++lineNumber;
                    colNumber = 1;
                }
                chunk = text.substring(from);
                ctx.appendText(chunk);
                ctx.closeSection();
                continue;
            }
            if (block instanceof ASTNode.URL) {
                ASTNode.URL url = (ASTNode.URL)block;
                MethodInvocation mi = url.getInvocation();
                ctx.writer.url(mi.getClassName(), mi.getMethodName(), mi.getMethodArguments());
                continue;
            }
            if (block instanceof ASTNode.Tag) {
                ASTNode.Tag tag = (ASTNode.Tag)block;
                TagHandler handler = this.get(tag);
                String className = handler.getClass().getName();
                if (tag.getChildren() != null) {
                    ctx.writer.openTag(className, tag.getArgs());
                    this.doEmit(ctx, tag.getChildren());
                    ctx.writer.closeTag(className, tag.getArgs());
                    continue;
                }
                ctx.writer.tag(className, tag.getArgs());
                continue;
            }
            if (block instanceof ASTNode.Message) {
                ASTNode.Message message = (ASTNode.Message)block;
                String key = message.getKey();
                ctx.writer.message(key);
                continue;
            }
            throw new AssertionError((Object)("Cannot such block " + block));
        }
    }
}

