/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.bridge.ViewStreamable;
import juzu.impl.common.Formatting;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopedContext;
import juzu.io.Stream;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.RequestParameter;
import juzu.request.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebBridge {
    public final void send(Response.Error error, boolean verbose) throws IOException {
        if (verbose) {
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            Formatting.renderStyleSheet(writer);
            writer.append("<div class=\"juzu\">");
            Throwable cause = error.getCause();
            if (cause != null) {
                Formatting.renderThrowable(null, writer, cause);
            } else {
                writer.append(error.getMessage());
            }
            writer.append("</div>");
            writer.close();
            this.send(Response.content(500, buffer.getBuffer()).withMimeType("text/html"));
        } else {
            this.setStatus(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(Response.Status response) throws IOException {
        PropertyMap properties = response.getProperties();
        Integer status = response.getCode();
        if (status != null) {
            this.setStatus(status);
        }
        if (response instanceof Response.Body) {
            Response.Body body = (Response.Body)response;
            Charset charset = body.getCharset();
            if (charset == null) {
                charset = Tools.ISO_8859_1;
            }
            this.setContentType(body.getMimeType(), charset);
            Iterable<Map.Entry<String, String[]>> headers = properties.getValues(PropertyType.HEADER);
            if (headers != null) {
                for (Map.Entry<String, String[]> entry : headers) {
                    this.setHeader(entry.getKey(), entry.getValue()[0]);
                }
            }
            Stream stream = this.getStream(charset);
            ViewStreamable vs = new ViewStreamable(body){

                public void renderAssetURL(AssetLocation location, String uri, Appendable appendable) throws IOException {
                    WebBridge.this.renderAssetURL(location, uri, appendable);
                }
            };
            try {
                vs.send(stream);
            }
            finally {
                this.end(stream);
            }
        }
        try {
            Iterable<Map.Entry<String, String[]>> headers = properties.getValues(PropertyType.HEADER);
            if (headers != null) {
                for (Map.Entry<String, String[]> entry : headers) {
                    this.setHeader(entry.getKey(), entry.getValue()[0]);
                }
            }
        }
        finally {
            this.end();
        }
    }

    protected void end(Stream stream) {
    }

    protected void end() {
    }

    public abstract Map<String, RequestParameter> getParameters();

    public abstract String getRequestURI();

    public abstract String getPath();

    public abstract String getRequestPath();

    public abstract void renderRequestURL(Appendable var1) throws IOException;

    public abstract void renderAssetURL(AssetLocation var1, String var2, Appendable var3) throws IOException;

    public abstract ScopedContext getRequestScope(boolean var1);

    public abstract ScopedContext getFlashScope(boolean var1);

    public abstract ScopedContext getSessionScope(boolean var1);

    public abstract void purgeSession();

    public abstract HttpContext getHttpContext();

    public abstract ClientContext getClientContext();

    public abstract UserContext getUserContext();

    public abstract ApplicationContext getApplicationContext();

    public abstract void setContentType(String var1, Charset var2);

    public abstract void setStatus(int var1);

    public abstract void setHeader(String var1, String var2);

    public abstract void sendRedirect(String var1) throws IOException;

    public abstract Stream getStream(Charset var1) throws IOException;
}

