/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.compiler;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.tags.DecorateTag;
import juzu.impl.tags.IncludeTag;
import juzu.impl.tags.InsertTag;
import juzu.impl.tags.ParamTag;
import juzu.impl.tags.TitleTag;
import juzu.impl.template.spi.juzu.ast.ASTNode;
import juzu.template.TagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationPhase {
    private final Map<String, TagHandler> tags = new HashMap<String, TagHandler>();
    private final IdentityHashMap<ASTNode.Tag, TagHandler> tagHandlers = new IdentityHashMap();

    public CompilationPhase() {
        this.tags.put("include", new IncludeTag());
        this.tags.put("insert", new InsertTag());
        this.tags.put("decorate", new DecorateTag());
        this.tags.put("title", new TitleTag());
        this.tags.put("param", new ParamTag());
    }

    public TagHandler resolveTag(String name) {
        return this.tags.get(name);
    }

    public TagHandler get(ASTNode.Tag node) {
        return this.tagHandlers.get(node);
    }

    protected void doAttribute(ASTNode<?> node) throws ProcessingException {
        block4: {
            block3: {
                if (!(node instanceof ASTNode.Template)) break block3;
                for (ASTNode.Block<?> child : node.getChildren()) {
                    this.doAttribute(child);
                }
                break block4;
            }
            if (node instanceof ASTNode.Section || node instanceof ASTNode.URL || !(node instanceof ASTNode.Tag)) break block4;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            TagHandler handler = this.resolveTag(nodeTag.getName());
            if (handler == null) {
                throw new UnsupportedOperationException("handle me gracefully " + nodeTag.getName());
            }
            this.tagHandlers.put(nodeTag, handler);
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doAttribute(child);
            }
        }
    }

    protected void doUnattribute(ASTNode<?> node) throws ProcessingException {
        block3: {
            block2: {
                if (!(node instanceof ASTNode.Template)) break block2;
                for (ASTNode.Block<?> child : node.getChildren()) {
                    this.doUnattribute(child);
                }
                break block3;
            }
            if (node instanceof ASTNode.Section || node instanceof ASTNode.URL || !(node instanceof ASTNode.Tag)) break block3;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            this.tagHandlers.remove(nodeTag);
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doAttribute(child);
            }
        }
    }
}

