/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.powerassert;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.powerassert.AssertionRenderer;
import org.codehaus.groovy.transform.powerassert.PowerAssertionError;
import org.codehaus.groovy.transform.powerassert.ValueRecorder;

public abstract class AssertionVerifier {
    public static final String VERIFY_METHOD_NAME = "verify";
    private static final String LOG_FILE = null;

    public static void verify(Object truthValue, String text, ValueRecorder recorder) {
        if (LOG_FILE != null) {
            AssertionVerifier.log(text, recorder);
        }
        if (!DefaultTypeTransformation.castToBoolean(truthValue)) {
            String msg = AssertionRenderer.render(text, recorder);
            PowerAssertionError error = new PowerAssertionError(msg);
            AssertionVerifier.filterStackTrace((Throwable)((Object)error));
            throw error;
        }
    }

    private static void log(String text, ValueRecorder recorder) {
        FileWriter out = null;
        try {
            out = new FileWriter(LOG_FILE, true);
            out.write(AssertionRenderer.render(text, recorder));
            out.write("\n\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    ((Writer)out).close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    private static void filterStackTrace(Throwable error) {
        StackTraceElement[] stackTrace = error.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement elem = stackTrace[i];
            if (elem.getClassName().startsWith("org.codehaus.groovy.transform.powerassert") || elem.getClassName().startsWith("org.codehaus.groovy.runtime.callsite")) continue;
            StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length - i];
            System.arraycopy(stackTrace, i, newStackTrace, 0, newStackTrace.length);
            error.setStackTrace(newStackTrace);
            return;
        }
    }
}

