/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.vertx;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.http.Cookie;
import juzu.Method;
import juzu.Response;
import juzu.bridge.vertx.Application;
import juzu.bridge.vertx.VertxRequestContext;
import juzu.bridge.vertx.VertxUserContext;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.bridge.spi.servlet.ServletScopedContext;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebRequestContext;
import juzu.impl.common.Logger;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.UserContext;

public class VertxWebBridge
extends WebBridge
implements HttpContext {
    private static final ApplicationContext APPLICATION_CONTEXT = new ApplicationContext(){

        public ResourceBundle resolveBundle(Locale locale) {
            return null;
        }
    };
    private final Application application;
    private ScopedContext requestScope;
    private final Bridge bridge;
    final VertxRequestContext ctx;

    public VertxWebBridge(Bridge bridge, VertxRequestContext ctx, Application application) {
        this.application = application;
        this.requestScope = null;
        this.bridge = bridge;
        this.ctx = ctx;
    }

    public Logger getLogger(String name) {
        return null;
    }

    public void execute(Runnable runnable) throws RejectedExecutionException {
        throw new RejectedExecutionException("Not yet implemented");
    }

    void handle(Handler handler) {
        try {
            handler.handle((WebBridge)this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                this.ctx.send(Response.error((Throwable)throwable).result(), true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public WebRequestContext getRequestContext() {
        return this.ctx;
    }

    public void renderRequestURL(Appendable appendable) throws IOException {
        appendable.append("http://localhost:8080");
    }

    public ScopedContext getRequestScope(boolean create) {
        if (this.requestScope == null && create) {
            this.requestScope = new ServletScopedContext(this.ctx.log);
        }
        return this.requestScope;
    }

    public ScopedContext getFlashScope(boolean create) {
        return this.ctx.getCookieScopeContext(0, create);
    }

    public ScopedContext getSessionScope(boolean create) {
        return this.ctx.getCookieScopeContext(1, create);
    }

    public void purgeSession() {
        throw new UnsupportedOperationException("todo");
    }

    public HttpContext getHttpContext() {
        return this;
    }

    public ClientContext getClientContext() {
        throw new UnsupportedOperationException("todo");
    }

    public ApplicationContext getApplicationContext() {
        return APPLICATION_CONTEXT;
    }

    public UserContext getUserContext() {
        return VertxUserContext.INSTANCE;
    }

    public Method getMethod() {
        return this.ctx.method;
    }

    public Cookie[] getCookies() {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "http";
    }

    public int getServerPort() {
        return this.application.port;
    }

    public String getServerName() {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        return "/";
    }
}

