/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Request;

public class AssetServer {
    HashSet<Application> runtimes = new HashSet();
    private static final ThreadLocal<AssetServer> current = new ThreadLocal();

    public void register(Application assetManager) {
        this.runtimes.add(assetManager);
    }

    public void unregister(Application assetManager) {
        this.runtimes.remove(assetManager);
    }

    public boolean doGet(String path, ServletContext ctx, HttpServletResponse resp) throws ServletException, IOException {
        if (path != null && path.length() > 0) {
            for (Application runtime : this.runtimes) {
                Iterable<AssetManager> resolvers = runtime.resolveBeans(AssetManager.class);
                for (AssetManager resolver : resolvers) {
                    URL content = resolver.resolveURL(AssetLocation.APPLICATION, path);
                    InputStream in = content != null ? content.openStream() : ctx.getResourceAsStream(path);
                    if (in == null) continue;
                    int pos = path.lastIndexOf(47);
                    String name = pos == -1 ? path : path.substring(pos + 1);
                    String contentType = ctx.getMimeType(name);
                    if (contentType != null) {
                        resp.setContentType(contentType);
                    }
                    Tools.copy(in, resp.getOutputStream());
                    return true;
                }
            }
        }
        return false;
    }

    public static String renderAssetURL(String path) throws NullPointerException {
        return AssetServer.renderAssetURL(AssetLocation.APPLICATION, path);
    }

    public static String renderAssetURL(AssetLocation location, String uri) throws NullPointerException {
        Request current = Request.getCurrent();
        if (current != null) {
            StringBuilder buffer = new StringBuilder();
            switch (location) {
                case APPLICATION: {
                    current.renderAssetURL(location, uri, buffer);
                    break;
                }
                default: {
                    current.renderAssetURL(location, uri, buffer);
                }
            }
            return buffer.toString();
        }
        return null;
    }
}

