/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.amd;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juzu.asset.AssetLocation;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.amd.ModuleAsset;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.asset.Asset;
import juzu.impl.plugin.asset.AssetsMetaModel;
import juzu.plugin.amd.Modules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmdMetaModelPlugin
extends ApplicationMetaModelPlugin {
    private static final Asset REQUIRE_JS = new Asset("juzu.amd", "script", "/juzu/impl/plugin/amd/require.js", Collections.<String>emptyList(), AssetLocation.APPLICATION);

    public AmdMetaModelPlugin() {
        super("amd");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Modules.class);
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (metaModel.getHandle().equals(key.getElement())) {
            List value = (List)added.get("value");
            AssetsMetaModel assetsMetaModel = metaModel.getChild(AssetsMetaModel.KEY);
            assetsMetaModel.removeAssets("module");
            ArrayList<ModuleAsset> list = new ArrayList<ModuleAsset>();
            for (Map map : value) {
                HashMap<String, Serializable> asset = new HashMap<String, Serializable>((AnnotationState)map.get("value"));
                if (asset.get("location") == null) {
                    asset.put("location", (Serializable)((Object)AssetLocation.APPLICATION.name()));
                }
                if (asset.get("id") == null) {
                    asset.put("id", asset.get("value"));
                }
                List aliases = (List)map.get("aliases");
                String adapter = (String)map.get("adapter");
                list.add(new ModuleAsset(asset, adapter, aliases));
            }
            for (Asset asset : list) {
                assetsMetaModel.addAsset(asset);
            }
            assetsMetaModel.addAsset(REQUIRE_JS);
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (metaModel.getHandle().equals(key.getElement())) {
            AssetsMetaModel assetsMetaModel = metaModel.getChild(AssetsMetaModel.KEY);
            assetsMetaModel.removeAssets("module");
            assetsMetaModel.removeAsset(REQUIRE_JS);
        }
    }
}

