/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.io.UndeclaredIOException;
import juzu.request.Phase;
import juzu.request.RequestParameter;
import juzu.request.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerPlugin
extends ApplicationPlugin
implements RequestFilter {
    private ControllersDescriptor descriptor;
    public ArrayList<RequestFilter> filters;
    @Inject
    private Application application;

    public ControllerPlugin() {
        super("controller");
    }

    public Application getApplication() {
        return this.application;
    }

    public ControllersDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ControllerResolver<Method> getResolver() {
        return this.descriptor != null ? this.descriptor.getResolver() : null;
    }

    @Override
    public PluginDescriptor init(PluginContext context) throws Exception {
        this.descriptor = new ControllersDescriptor(context.getClassLoader(), context.getConfig());
        return this.descriptor;
    }

    public InjectionContext<?, ?> getInjectionContext() {
        return this.application.getInjectionContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(RequestBridge bridge) {
        block10: {
            Phase phase = bridge.getPhase();
            Map<String, RequestParameter> parameters = bridge.getRequestParameters();
            MethodHandle handle = bridge.getTarget();
            Method method = this.descriptor.getMethodByHandle(handle);
            if (method == null) {
                StringBuilder sb = new StringBuilder("handle me gracefully : no method could be resolved for phase=").append(phase).append(" handle=").append(handle).append(" parameters={");
                int index = 0;
                for (RequestParameter parameter : parameters.values()) {
                    if (index++ > 0) {
                        sb.append(',');
                    }
                    sb.append(parameter.getName()).append("=[");
                    for (int i = 0; i < parameter.size(); ++i) {
                        if (i > 0) {
                            sb.append(',');
                        }
                        sb.append(parameter.get(i));
                    }
                    sb.append(']');
                }
                sb.append("}");
                throw new UnsupportedOperationException(sb.toString());
            }
            Request request = new Request(this, method, parameters, bridge);
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader classLoader = this.application.getClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                bridge.begin(request);
                request.invoke();
                Result result = request.getResult();
                if (result == null) break block10;
                try {
                    bridge.setResult(result);
                }
                catch (IOException e) {
                    throw new UndeclaredIOException(e);
                }
            }
            finally {
                bridge.end();
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    @Override
    public void invoke(Request request) {
        request.invoke();
    }

    private <T> void tryInject(Request request, ContextualParameter parameter, Class<T> type, T instance) {
        if (instance != null && type.isAssignableFrom(parameter.getType())) {
            request.setArgument(parameter, instance);
        }
    }
}

