/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.InjectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeConfig {
    public static final String INJECT = "juzu.inject";
    public static final String APP_NAME = "juzu.app_name";
    public static final String REQUEST_ENCODING = "juzu.request_encoding";
    public static final Set<String> NAMES = Collections.unmodifiableSet(Tools.set("juzu.inject", "juzu.app_name", "juzu.request_encoding"));
    public final Name name;
    public final InjectorProvider injectorProvider;
    public final Charset requestEncoding;

    public BridgeConfig(Logger log, Map<String, String> config) throws Exception {
        this.name = this.getApplicationName(config);
        this.injectorProvider = this.getInjectImplementation(log, config);
        this.requestEncoding = this.getRequestEncoding(config);
    }

    private Name getApplicationName(Map<String, String> config) {
        String applicationName = config.get(APP_NAME);
        return applicationName != null ? Name.parse(applicationName) : null;
    }

    private InjectorProvider getInjectImplementation(Logger log, Map<String, String> config) throws Exception {
        String inject = config.get(INJECT);
        if (inject == null) {
            log.debug("No inject implementation specified will detect one available");
            TreeMap<Integer, InjectorProvider> providers = new TreeMap<Integer, InjectorProvider>();
            for (InjectorProvider provider : InjectorProvider.values()) {
                if (provider.isAvailable()) {
                    log.debug("Inject implementation " + provider.getValue() + " available");
                    providers.put(provider.getPriority(), provider);
                    continue;
                }
                log.debug("Inject implementation " + provider.getValue() + " not available");
            }
            Iterator i = providers.values().iterator();
            if (i.hasNext()) {
                InjectorProvider implementation = (InjectorProvider)((Object)i.next());
                log.debug("Selected " + implementation.get() + " inject implementation");
                return implementation;
            }
            log.debug("No inject implementation available");
            return null;
        }
        InjectorProvider implementation = InjectorProvider.find(inject = inject.trim().toLowerCase());
        if (implementation == null) {
            log.debug("Inject implementation " + inject + " not available");
            return null;
        }
        return implementation;
    }

    private Charset getRequestEncoding(Map<String, String> config) {
        String requestEncodingParam = config.get(REQUEST_ENCODING);
        if (requestEncodingParam != null) {
            requestEncodingParam = Tools.interpolate(requestEncodingParam, System.getProperties());
            return Charset.forName(requestEncodingParam);
        }
        return Tools.ISO_8859_1;
    }
}

