/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;
import juzu.impl.plugin.asset.AssetKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Asset
implements Serializable {
    public final String id;
    public final String type;
    public final List<String> depends;
    public final AssetKey key;

    public Asset(String type, Map<String, Serializable> asset) {
        String id = (String)((Object)asset.get("id"));
        String value = (String)((Object)asset.get("value"));
        List depends = (List)((Object)asset.get("depends"));
        AssetLocation location = AssetLocation.safeValueOf((String)((Object)asset.get("location")));
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (id == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        if (location == null) {
            throw new IllegalArgumentException("No null location accepted");
        }
        this.id = id;
        this.type = type;
        this.depends = depends != null ? depends : new ArrayList();
        this.key = new AssetKey(value, location);
    }

    public Asset(String id, String type, String value, List<String> depends, AssetLocation location) {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (value == null) {
            throw new NullPointerException("No null value accepted");
        }
        if (location == null) {
            throw new NullPointerException("No null location accepted");
        }
        this.id = id;
        this.type = type;
        this.depends = depends;
        this.key = new AssetKey(value, location);
    }

    public boolean isApplication() {
        return this.key.location == AssetLocation.APPLICATION;
    }

    public JSON getJSON() {
        JSON json = new JSON().set("id", this.id).set("value", this.key.value).set("location", this.key.location.toString()).set("type", this.type);
        if (this.depends != null) {
            json.set("depends", this.depends);
        }
        return json;
    }

    public InputStream filter(InputStream stream) throws IOException {
        return stream;
    }
}

