/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AssetGraph
extends HashMap<String, Set<String>> {
    AssetGraph() {
    }

    AssetGraph(AssetGraph that) {
        super(that);
    }

    boolean register(String id, String deployedId) {
        if (this.check(deployedId, id)) {
            HashSet<String> a = (HashSet<String>)this.get(id);
            if (a == null) {
                this.put(id, Collections.singleton(deployedId));
            } else if (!(a instanceof HashSet)) {
                a = new HashSet<String>(a);
                a.add(deployedId);
                this.put(id, Collections.unmodifiableSet(a));
            }
            return true;
        }
        return false;
    }

    void unregister(String id, String deployedId) {
        HashSet a = new HashSet((Collection)this.get(id));
        a.remove(deployedId);
        this.put(id, Collections.unmodifiableSet(a));
    }

    private boolean check(String node, String id) {
        Set s = (Set)this.get(node);
        if (s != null && s.size() > 0) {
            if (s.contains(id)) {
                return false;
            }
            for (String t : s) {
                if (this.check(t, id)) continue;
                return false;
            }
        }
        return true;
    }
}

