/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import juzu.impl.common.Logger;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProcessor
extends AbstractProcessor {
    private static final String lineSep = System.getProperty("line.separator");
    private static final ThreadLocal<Formatter> currentLog = new ThreadLocal();
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static final Logger logger = BaseProcessor.getLogger(BaseProcessor.class);
    private boolean formalErrorReporting = false;
    private ProcessingContext context;

    public static Logger getLogger(Class<?> type) {
        String key = type.getName();
        final String name = type.getSimpleName();
        Logger logger = loggers.get(key);
        if (logger == null) {
            logger = new Logger(){

                protected void send(Level level, CharSequence msg, Throwable t) {
                    BaseProcessor.log(name, level, msg, t);
                }
            };
            loggers.put(key, logger);
        }
        return logger;
    }

    private static void log(String name, Level level, CharSequence msg, Throwable t) {
        Formatter sb = currentLog.get();
        if (sb != null) {
            sb.format("%1$tH:%1$tM,%1$tS:%1$tL %2$-7s [%3$s]: %4$s", System.currentTimeMillis(), level.getName(), name, msg);
            sb.format(lineSep, new Object[0]);
            if (t != null) {
                StringWriter buffer = new StringWriter();
                t.printStackTrace(new PrintWriter(buffer));
                sb.format("%1$s", buffer);
            }
        }
    }

    protected BaseProcessor() {
    }

    public final boolean getFormalErrorReporting() {
        return this.formalErrorReporting;
    }

    public final ProcessingContext getContext() {
        return this.context;
    }

    @Override
    public final Set<String> getSupportedOptions() {
        Set<String> options = super.getSupportedOptions();
        HashSet<String> our = new HashSet<String>(options);
        our.add("juzu.error_reporting");
        return our;
    }

    @Override
    public final void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        currentLog.set(new Formatter());
        this.formalErrorReporting = "formal".equalsIgnoreCase(processingEnv.getOptions().get("juzu.error_reporting"));
        this.context = new ProcessingContext(processingEnv);
        this.doInit(this.context);
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    protected void doInit(ProcessingContext context) {
    }

    /*
     * Exception decompiling
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws ProcessingException;
}

