/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.animal_sniffer;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Main {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: java -jar animal-sniffer.jar [JAR/CLASS FILES]");
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            Main.process(new File(args[i]));
        }
    }

    private static void process(File file) throws IOException {
        if (file.isDirectory()) {
            Main.processDirectory(file);
        } else if (file.getName().endsWith(".class")) {
            Main.processClassFile(file);
        } else if (file.getName().endsWith(".jar")) {
            Main.processJarFile(file);
        }
    }

    private static void processDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            Main.process(files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJarFile(File file) throws IOException {
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry x = e.nextElement();
            if (!x.getName().endsWith(".class")) continue;
            InputStream is = jar.getInputStream(x);
            try {
                Main.process(file.getPath() + ':' + x.getName(), is);
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processClassFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Main.process(file.getPath(), in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static void process(String name, InputStream image) throws IOException {
        DataInputStream dis = new DataInputStream(image);
        byte[] buf = new byte[8];
        dis.readFully(buf);
        System.out.println(Main.u2(buf[6], buf[7]) + "." + Main.u2(buf[4], buf[5]) + " " + name);
    }

    private static int u2(byte u, byte d) {
        return u * 256 + d;
    }
}

