/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.animal_sniffer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.zip.GZIPOutputStream;
import org.jvnet.animal_sniffer.ClassFileVisitor;
import org.jvnet.animal_sniffer.Clazz;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class SignatureBuilder
extends ClassFileVisitor {
    private boolean foundSome;
    private final ObjectOutputStream oos;

    public static void main(String[] args) throws IOException {
        SignatureBuilder builder = new SignatureBuilder(new FileOutputStream("signature"));
        builder.process(new File(System.getProperty("java.home"), "lib/rt.jar"));
        builder.close();
    }

    public SignatureBuilder(OutputStream out) throws IOException {
        this.oos = new ObjectOutputStream(new GZIPOutputStream(out));
    }

    public void close() throws IOException {
        this.oos.writeObject(null);
        this.oos.close();
        if (!this.foundSome) {
            throw new IOException("No index is written");
        }
    }

    protected void process(String name, InputStream image) throws IOException {
        System.out.println(name);
        this.foundSome = true;
        ClassReader cr = new ClassReader(image);
        SignatureVisitor v = new SignatureVisitor();
        cr.accept((ClassVisitor)v, 0);
        v.end();
    }

    private class SignatureVisitor
    extends EmptyVisitor {
        Clazz clazz;

        private SignatureVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.clazz = new Clazz(name, new HashSet(), superName, interfaces);
        }

        public void end() throws IOException {
            SignatureBuilder.this.oos.writeObject(this.clazz);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.clazz.signatures.add(name + desc);
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.clazz.signatures.add(name + "#" + desc);
            return null;
        }
    }
}

