/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jvnet.annox.model.XAnnotationField;
import org.jvnet.annox.model.XAnnotationVisitor;
import org.jvnet.annox.parser.XAnnotationFieldParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAnnotation {
    public static XAnnotation[] EMPTY_ARRAY = new XAnnotation[0];
    private final Class<? extends Annotation> annotationClass;
    private final Map<String, XAnnotationField<?>> fieldsMap;
    private final Set<XAnnotationField<?>> fieldsSet;
    private final List<XAnnotationField<?>> fieldsList;

    public XAnnotation(Class<? extends Annotation> annotationClass, XAnnotationField<?> ... fields) throws IllegalArgumentException {
        Validate.notNull(annotationClass, (String)"Annotation class must not be null.");
        this.annotationClass = annotationClass;
        List<XAnnotationField<?>> fieldsList = Collections.unmodifiableList(XAnnotation.toFieldsList(fields));
        Map<String, XAnnotationField<?>> fieldsMap = Collections.unmodifiableMap(XAnnotation.toFieldsMap(annotationClass.getMethods(), fieldsList));
        this.checkFieldsMap(fieldsMap);
        this.fieldsList = fieldsList;
        this.fieldsMap = fieldsMap;
        this.fieldsSet = Collections.unmodifiableSet(new HashSet(fieldsMap.values()));
    }

    private static List<XAnnotationField<?>> toFieldsList(XAnnotationField<?>[] fields) {
        if (fields == null) {
            return Collections.emptyList();
        }
        ArrayList fieldsList = new ArrayList(fields.length);
        for (XAnnotationField<?> field : fields) {
            if (field == null) continue;
            fieldsList.add(field);
        }
        return fieldsList;
    }

    private static Map<String, XAnnotationField<?>> toFieldsMap(Method[] methods, List<XAnnotationField<?>> fieldsList) {
        HashMap definedFieldsMap = new HashMap();
        if (fieldsList != null) {
            for (XAnnotationField<?> definedField : fieldsList) {
                if (definedField == null) {
                    throw new IllegalArgumentException("Fields array must not contain null entries.");
                }
                definedFieldsMap.put(definedField.getName(), definedField);
            }
        }
        HashMap fieldsMap = new HashMap();
        for (Method method : methods) {
            XAnnotationField field;
            if (Annotation.class.equals(method.getDeclaringClass())) continue;
            String name = method.getName();
            Class<?> fieldType = method.getReturnType();
            XAnnotationField definedField = (XAnnotationField)definedFieldsMap.get(name);
            if (definedField == null) {
                Object defaultValue = method.getDefaultValue();
                if (defaultValue == null) {
                    throw new IllegalArgumentException("Field [" + name + "] is not defined and it has no default value.");
                }
                try {
                    field = XAnnotationFieldParser.GENERIC.construct(name, defaultValue, fieldType);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Field [" + name + "] could not be parsed.", ex);
                }
            } else {
                Class<?> definedFieldType = definedField.getType();
                if (!fieldType.equals(definedFieldType)) {
                    throw new IllegalArgumentException("Field [" + name + "] has the wrong type [" + definedFieldType + "] instead of expected [" + fieldType + "].");
                }
                field = definedField;
            }
            fieldsMap.put(field.getName(), field);
        }
        return fieldsMap;
    }

    private void checkFieldsMap(Map<String, XAnnotationField<?>> fieldsMap) {
        Method[] methods;
        for (Method method : methods = this.annotationClass.getMethods()) {
            if (Annotation.class.equals(method.getDeclaringClass())) continue;
            String name = method.getName();
            Class<?> type = method.getReturnType();
            XAnnotationField<?> field = fieldsMap.get(name);
            if (field == null) {
                throw new IllegalArgumentException("Field [" + name + "] is not defined.");
            }
            Class<?> fieldType = field.getType();
            if (type.equals(fieldType)) continue;
            throw new IllegalArgumentException("Field [" + name + "] has the wrong type [" + field.getType() + "] instead of expected [" + type + "].");
        }
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public List<XAnnotationField<?>> getFieldsList() {
        return this.fieldsList;
    }

    public Map<String, XAnnotationField<?>> getFieldsMap() {
        return this.fieldsMap;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 37 + this.annotationClass.hashCode();
        hash = hash * 37 + ((Object)this.fieldsSet).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XAnnotation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        XAnnotation other = (XAnnotation)obj;
        return this.annotationClass.equals(other.annotationClass) && ((Object)this.fieldsSet).equals(other.fieldsSet);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("@");
        sb.append(this.getAnnotationClass().getName());
        sb.append("(");
        for (int index = 0; index < this.fieldsList.size(); ++index) {
            XAnnotationField<?> field = this.fieldsList.get(index);
            if (index > 0) {
                sb.append(", ");
            }
            sb.append(field);
        }
        sb.append(")");
        return sb.toString();
    }

    public Annotation getResult() {
        HashMap<String, Object> draft = new HashMap<String, Object>();
        for (Map.Entry<String, XAnnotationField<?>> entry : this.fieldsMap.entrySet()) {
            draft.put(entry.getKey(), entry.getValue().getResult());
        }
        final Map map = Collections.unmodifiableMap(draft);
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String name = method.getName();
                if (!Annotation.class.equals(method.getDeclaringClass())) {
                    return map.get(name);
                }
                if ("annotationType".equals(name)) {
                    return XAnnotation.this.annotationClass;
                }
                return null;
            }
        };
        Annotation annotation = (Annotation)Proxy.newProxyInstance(this.annotationClass.getClassLoader(), new Class[]{this.annotationClass}, handler);
        return annotation;
    }

    public <T> T accept(XAnnotationVisitor<T> visitor) {
        return visitor.visitAnnotation(this);
    }
}

