/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import org.apache.commons.lang.Validate;
import org.jvnet.annox.model.XAnnotationVisitor;
import org.jvnet.annox.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XAnnotationField<T> {
    private final String name;

    public String getName() {
        return this.name;
    }

    public abstract T getValue();

    protected Object getInternalValue() {
        return this.getValue();
    }

    public Object getResult() {
        return this.getValue();
    }

    public abstract Class<?> getType();

    public abstract <P> P accept(XAnnotationVisitor<P> var1);

    public XAnnotationField(String name) {
        Validate.notNull((Object)name, (String)"Field name must not be null.");
        this.name = name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XAnnotationArray
    extends XFixedArrayField<org.jvnet.annox.model.XAnnotation> {
        private final Class<? extends Annotation> annotationClass;

        public XAnnotationArray(String name, org.jvnet.annox.model.XAnnotation[] value, Class<? extends Annotation> annotationClass) {
            super(name, value);
            Validate.notNull(annotationClass, (String)"Annotation class must not be null.");
            this.annotationClass = annotationClass;
        }

        @Override
        public Class<?> getType() {
            return Array.newInstance(this.annotationClass, 0).getClass();
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitAnnotationArrayField(this);
        }

        @Override
        public Object getResult() {
            org.jvnet.annox.model.XAnnotation[] value = (org.jvnet.annox.model.XAnnotation[])this.getValue();
            Annotation[] result = (Annotation[])Array.newInstance(this.annotationClass, value.length);
            for (int index = 0; index < value.length; ++index) {
                org.jvnet.annox.model.XAnnotation annotation = value[index];
                result[index] = annotation.getResult();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XStringArray
    extends XFixedArrayField<String> {
        public XStringArray(String name, String[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return String[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitStringArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XEnumArray
    extends XFixedArrayField<Enum> {
        private final Class<? extends Enum> enumClass;

        public XEnumArray(String name, Enum[] value, Class<? extends Enum> enumClass) {
            super(name, value);
            Validate.notNull(enumClass, (String)"Enum class must not be null.");
            this.enumClass = enumClass;
        }

        @Override
        public Class<?> getType() {
            return Array.newInstance(this.enumClass, 0).getClass();
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitEnumArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XFloatArray
    extends XFixedArrayField<Float> {
        public XFloatArray(String name, Float[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return float[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitFloatArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XDoubleArray
    extends XFixedArrayField<Double> {
        public XDoubleArray(String name, Double[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return double[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitDoubleArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XClassArray
    extends XArrayField<Class> {
        private Class[] classes;
        private final String[] classNames;

        public XClassArray(String name, Class[] classes) {
            super(name);
            Validate.noNullElements((Object[])classes);
            this.classes = classes;
            this.classNames = new String[classes.length];
            for (int index = 0; index < classes.length; ++index) {
                this.classNames[index] = classes[index].getName();
            }
        }

        public XClassArray(String name, String[] classNames) {
            super(name);
            Validate.noNullElements((Object[])classNames);
            this.classes = null;
            this.classNames = classNames;
        }

        @Override
        public Class[] getValue() {
            if (this.classes != null) {
                return this.classes;
            }
            try {
                Class[] classes = new Class[this.classNames.length];
                for (int index = 0; index < this.classNames.length; ++index) {
                    classes[index] = Class.forName(this.classNames[index]);
                }
                this.classes = classes;
                return this.classes;
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public Object[] getInternalValue() {
            return this.getClassNames();
        }

        public String[] getClassNames() {
            return this.classNames;
        }

        @Override
        public Class<?> getType() {
            return Class[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitClassArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCharArray
    extends XFixedArrayField<Character> {
        public XCharArray(String name, Character[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return char[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitCharArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XShortArray
    extends XFixedArrayField<Short> {
        public XShortArray(String name, Short[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return short[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitShortArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XLongArray
    extends XFixedArrayField<Long> {
        public XLongArray(String name, Long[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return long[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitLongArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XIntArray
    extends XFixedArrayField<Integer> {
        public XIntArray(String name, Integer[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return int[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitIntArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XByteArray
    extends XFixedArrayField<Byte> {
        public XByteArray(String name, Byte[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return byte[].class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitByteArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XBooleanArray
    extends XFixedArrayField<Boolean> {
        public XBooleanArray(String name, Boolean[] value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return boolean[].class;
        }

        @Override
        public <P> P accept(XAnnotationVisitor<P> visitor) {
            return visitor.visitBooleanArrayField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class XFixedArrayField<T>
    extends XArrayField<T> {
        private T[] value;

        public XFixedArrayField(String name, T[] value) {
            super(name);
            Validate.noNullElements((Object[])value, (String)"Array must not contain null values.");
            this.value = value;
        }

        @Override
        public T[] getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class XArrayField<T>
    extends XAnnotationField<T[]> {
        public XArrayField(String name) {
            super(name);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getName());
            sb.append("=[");
            Object[] values = this.getInternalValue();
            for (int index = 0; index < values.length; ++index) {
                Object value = values[index];
                if (index > 0) {
                    sb.append(", ");
                }
                sb.append(value);
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            int hash = 0;
            String name = this.getName();
            hash = hash * 37 + name.hashCode();
            Object[] values = this.getInternalValue();
            for (int index = 0; index < values.length; ++index) {
                Object v = values[index];
                hash = hash * 37 + v.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            Object[] rhs;
            if (!(obj instanceof XArrayField)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            XArrayField other = (XArrayField)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            Object[] lhs = this.getInternalValue();
            if (lhs == (rhs = other.getInternalValue())) {
                return true;
            }
            if (lhs == null || rhs == null) {
                return false;
            }
            if (lhs.length != rhs.length) {
                return false;
            }
            for (int i = 0; i < lhs.length; ++i) {
                if (lhs[i].equals(rhs[i])) continue;
                return false;
            }
            return true;
        }

        public Object[] getInternalValue() {
            return (Object[])this.getValue();
        }

        @Override
        public Object getResult() {
            return ArrayUtils.asPrimitiveArray(this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XAnnotation
    extends XFixedField<org.jvnet.annox.model.XAnnotation> {
        private final Class<? extends Annotation> annotationClass;

        public XAnnotation(String name, org.jvnet.annox.model.XAnnotation value, Class<? extends Annotation> annotationClass) {
            super(name, value);
            Validate.notNull(annotationClass, (String)"Annotation class must not be null.");
            this.annotationClass = annotationClass;
        }

        @Override
        public Class<?> getType() {
            return this.annotationClass;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitAnnotationField(this);
        }

        @Override
        public Object getResult() {
            return ((org.jvnet.annox.model.XAnnotation)this.getValue()).getResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XString
    extends XFixedField<String> {
        public XString(String name, String value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return String.class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitStringField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XEnum
    extends XFixedField<Enum> {
        private final Class<? extends Enum> enumClass;

        public XEnum(String name, Enum value, Class<? extends Enum> enumClass) {
            super(name, value);
            Validate.notNull(enumClass, (String)"Enum class must not be null.");
            this.enumClass = enumClass;
        }

        @Override
        public Class<?> getType() {
            return this.enumClass;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitEnumField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XFloat
    extends XFixedField<Float> {
        public XFloat(String name, Float value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return Float.TYPE;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitFloatField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XDouble
    extends XFixedField<Double> {
        public XDouble(String name, Double value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return Double.TYPE;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitDoubleField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XClass
    extends XField<Class> {
        private Class theClass;
        private final String className;

        public XClass(String name, Class theClass) {
            super(name);
            Validate.notNull((Object)theClass, (String)"Class must not be null.");
            this.theClass = theClass;
            this.className = theClass.getName();
        }

        public XClass(String name, String className) {
            super(name);
            Validate.notNull((Object)className, (String)"Class name must not be null.");
            this.theClass = null;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public Class<?> getType() {
            return Class.class;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitClassField(this);
        }

        @Override
        protected Object getInternalValue() {
            return this.getClassName();
        }

        @Override
        public Class getValue() {
            if (this.theClass != null) {
                return this.theClass;
            }
            try {
                this.theClass = Class.forName(this.className);
                return this.theClass;
            }
            catch (ClassNotFoundException cnfex) {
                throw new IllegalArgumentException(cnfex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XChar
    extends XFixedField<Character> {
        public XChar(String name, Character value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return Character.TYPE;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitCharField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XShort
    extends XFixedField<Short> {
        public XShort(String name, Short value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return Short.TYPE;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitShortField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XLong
    extends XFixedField<Long> {
        public XLong(String name, Long value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return Long.TYPE;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitLongField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XInt
    extends XFixedField<Integer> {
        public XInt(String name, Integer value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return Integer.TYPE;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitIntField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XByte
    extends XFixedField<Byte> {
        public XByte(String name, Byte value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return Byte.TYPE;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitByteField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XBoolean
    extends XFixedField<Boolean> {
        public XBoolean(String name, Boolean value) {
            super(name, value);
        }

        @Override
        public Class<?> getType() {
            return Boolean.TYPE;
        }

        @Override
        public <T> T accept(XAnnotationVisitor<T> visitor) {
            return visitor.visitBooleanField(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class XFixedField<T>
    extends XField<T> {
        private T value;

        public XFixedField(String name, T value) {
            super(name);
            Validate.notNull(value, (String)"Field value must not be null.");
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class XField<T>
    extends XAnnotationField<T> {
        public XField(String name) {
            super(name);
        }

        public String toString() {
            return this.getName() + "=" + this.getInternalValue();
        }

        public int hashCode() {
            int hash = 0;
            String name = this.getName();
            hash = hash * 37 + name.hashCode();
            Object value = this.getInternalValue();
            hash = hash * 37 + value.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XAnnotationField)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            XAnnotationField other = (XAnnotationField)obj;
            return this.getName().equals(other.getName()) && this.getInternalValue().equals(other.getInternalValue());
        }
    }
}

