/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotationElementUtils {
    private AnnotationElementUtils() {
    }

    public static String getFieldValue(Element annotationElement, String name) {
        String value = null;
        String attribute = annotationElement.getAttribute(name);
        if (!StringUtils.isEmpty((String)attribute)) {
            value = attribute;
        }
        NodeList nodes = annotationElement.getChildNodes();
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            if (!AnnotationElementUtils.isFieldContainerElement(node, name)) continue;
            value = ((Element)node).getTextContent();
        }
        return value;
    }

    private static boolean isFieldContainerElement(Node node, String name) {
        Element element;
        return node.getNodeType() == 1 && (name.equals((element = (Element)node).getLocalName()) || name.equals(element.getAttributeNS("http://annox.dev.java.net", "field")));
    }

    public static Element getFieldElement(Element annotationElement, String name) {
        Element value = null;
        NodeList nodes = annotationElement.getChildNodes();
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            if (!AnnotationElementUtils.isFieldContainerElement(node, name)) continue;
            Element element = (Element)node;
            NodeList subelements = element.getChildNodes();
            for (int jndex = 0; jndex < subelements.getLength(); ++jndex) {
                Node subnode = subelements.item(jndex);
                if (subnode.getNodeType() != 1) continue;
                value = (Element)subnode;
            }
        }
        return value;
    }

    public static String[] getFieldValues(Element annotationElement, String name) {
        ArrayList<String> values = new ArrayList<String>();
        String attribute = annotationElement.getAttribute(name);
        if (!StringUtils.isEmpty((String)attribute)) {
            String[] entries = StringUtils.split((String)attribute.trim(), (char)' ');
            values.addAll(Arrays.asList(entries));
        }
        NodeList nodes = annotationElement.getChildNodes();
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            if (!AnnotationElementUtils.isFieldContainerElement(node, name)) continue;
            Element element = (Element)node;
            String entry = element.getTextContent();
            values.add(entry);
        }
        return values.isEmpty() ? new String[]{} : values.toArray(new String[values.size()]);
    }

    public static Element[] getFieldElements(Element annotationElement, String name) {
        ArrayList<Element> values = new ArrayList<Element>();
        NodeList nodes = annotationElement.getChildNodes();
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            if (!AnnotationElementUtils.isFieldContainerElement(node, name)) continue;
            Element element = (Element)node;
            NodeList subelements = element.getChildNodes();
            for (int jndex = 0; jndex < subelements.getLength(); ++jndex) {
                Node subnode = subelements.item(jndex);
                if (subnode.getNodeType() != 1) continue;
                values.add((Element)subnode);
            }
        }
        return values.isEmpty() ? new Element[]{} : values.toArray(new Element[values.size()]);
    }
}

