/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.util;

import java.lang.reflect.Array;
import org.apache.commons.lang.Validate;
import org.jvnet.annox.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtils {
    public static Object valueOf(Class<?> basicType, String value) throws ClassNotFoundException, NumberFormatException, IllegalArgumentException {
        if (value == null) {
            return null;
        }
        Class type = ClassUtils.primitiveToWrapper(basicType);
        if (Boolean.class.equals((Object)type)) {
            return Boolean.valueOf(value);
        }
        if (Byte.class.equals((Object)type)) {
            return Byte.valueOf(value);
        }
        if (Character.class.equals((Object)type)) {
            Validate.isTrue((value.length() == 1 ? 1 : 0) != 0, (String)"One character string expected.");
            return Character.valueOf(value.charAt(0));
        }
        if (Short.class.equals((Object)type)) {
            return Short.valueOf(value);
        }
        if (Integer.class.equals((Object)type)) {
            return Integer.valueOf(value);
        }
        if (Long.class.equals((Object)type)) {
            return Long.valueOf(value);
        }
        if (Double.class.equals((Object)type)) {
            return Double.valueOf(value);
        }
        if (Float.class.equals((Object)type)) {
            return Float.valueOf(value);
        }
        if (Enum.class.isAssignableFrom(type)) {
            Class enumClass = type;
            return Enum.valueOf(enumClass, value);
        }
        if (Class.class.equals((Object)type)) {
            return Class.forName(value);
        }
        if (String.class.equals((Object)type)) {
            return value;
        }
        throw new IllegalArgumentException("The type [" + basicType + "] is not recognized.");
    }

    public static Object[] valueOf(Class<?> basicType, String[] values) throws ClassNotFoundException, NumberFormatException, IllegalArgumentException {
        if (values == null) {
            return null;
        }
        Class type = ClassUtils.primitiveToWrapper(basicType);
        Object[] array = (Object[])Array.newInstance(type, values.length);
        for (int index = 0; index < values.length; ++index) {
            String value = values[index];
            array[index] = ObjectUtils.valueOf(type, value);
        }
        return array;
    }
}

