/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.apache.commons.lang.Validate;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.model.XMember;
import org.jvnet.annox.model.XParameter;
import org.jvnet.annox.reflect.ParameterizedAnnotatedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XConstructor
extends XMember<Constructor<?>>
implements ParameterizedAnnotatedElement {
    public static final XConstructor[] EMPTY_ARRAY = new XConstructor[0];
    private final XParameter[] parameters;

    public XConstructor(Constructor<?> constructor, XAnnotation[] xannotations, XParameter[] parameters) {
        super(constructor, xannotations);
        this.parameters = parameters;
        this.check();
    }

    public XParameter[] getParameters() {
        return this.parameters;
    }

    private void check() {
        Class<?>[] parameterTypes;
        Constructor<?> constructor = this.getConstructor();
        XParameter[] parameters = this.getParameters();
        Validate.isTrue((parameters.length == (parameterTypes = constructor.getParameterTypes()).length ? 1 : 0) != 0, (String)("Wrong number of parameters: [" + parameters.length + "], expected [" + parameterTypes.length + "]."));
        for (int index = 0; index < parameters.length; ++index) {
            XParameter parameter = parameters[index];
            Class<?> parameterType = parameterTypes[index];
            Validate.isTrue((boolean)parameterType.equals(parameter.getType()), (String)("Wrong parameter type: [" + parameter.getType() + "], expected [" + parameterType + "]"));
        }
    }

    public Constructor<?> getConstructor() {
        return (Constructor)this.getMember();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        XParameter[] xparameters = this.getParameters();
        Annotation[][] parameterAnnotations = new Annotation[xparameters.length][];
        for (int index = 0; index < xparameters.length; ++index) {
            parameterAnnotations[index] = xparameters[index].getAnnotations();
        }
        return parameterAnnotations;
    }
}

