/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jvnet.annox.annotation.AnnotationClassNotFoundException;
import org.jvnet.annox.annotation.NoSuchAnnotationFieldException;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.model.XAnnotationField;
import org.jvnet.annox.parser.AnnotationElementParseException;
import org.jvnet.annox.parser.XAnnotationFieldParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAnnotationParser {
    public static final XAnnotationParser GENERIC = new XAnnotationParser();

    public XAnnotation parse(Annotation annotation) {
        Validate.notNull((Object)annotation, (String)"Annotation must not be null.");
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        XAnnotationField<?>[] fields = this.parseFields(annotation);
        return new XAnnotation(annotationClass, fields);
    }

    public XAnnotation[] parse(Annotation[] annotations) {
        Validate.noNullElements((Object[])annotations, (String)"Annotations must not contain nulls.");
        XAnnotation[] xannotations = new XAnnotation[annotations.length];
        for (int index = 0; index < annotations.length; ++index) {
            Annotation annotation = annotations[index];
            xannotations[index] = this.parse(annotation);
        }
        return xannotations;
    }

    public XAnnotation parse(Element annotationElement) throws AnnotationElementParseException {
        String className;
        Validate.notNull((Object)annotationElement, (String)"Annotation element must not be null.");
        String name = annotationElement.getLocalName();
        String classAttribute = annotationElement.getAttributeNS("http://annox.dev.java.net", "class");
        if (!StringUtils.isEmpty((String)classAttribute)) {
            className = classAttribute;
        } else {
            String namespaceURI = annotationElement.getNamespaceURI();
            if (namespaceURI != null && namespaceURI.startsWith("http://annox.dev.java.net/")) {
                String containerPrefix = namespaceURI.substring("http://annox.dev.java.net/".length());
                className = containerPrefix + "." + name;
            } else {
                className = name;
            }
        }
        try {
            Class<?> draftClass = Class.forName(className);
            if (!Annotation.class.isAssignableFrom(draftClass)) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)new IllegalArgumentException("The class [" + draftClass.getName() + "] is not an annotation class."));
            }
            Class<?> annotationClass = draftClass;
            XAnnotationField<?>[] fields = this.parseFields(annotationElement, annotationClass);
            return new XAnnotation(annotationClass, fields);
        }
        catch (ClassNotFoundException cnfex) {
            throw new AnnotationElementParseException(annotationElement, (Throwable)new AnnotationClassNotFoundException(className, cnfex));
        }
        catch (AnnotationElementParseException cnfex) {
            throw new AnnotationElementParseException(annotationElement, (Throwable)new AnnotationClassNotFoundException(className, cnfex));
        }
    }

    public XAnnotation[] parse(Element[] annotationElements) throws AnnotationElementParseException {
        Validate.noNullElements((Object[])annotationElements, (String)"Annotation elements must not contain null.");
        XAnnotation[] xannotations = new XAnnotation[annotationElements.length];
        for (int index = 0; index < annotationElements.length; ++index) {
            Element annotationElement = annotationElements[index];
            try {
                xannotations[index] = this.parse(annotationElement);
                continue;
            }
            catch (AnnotationElementParseException aepex) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
            }
        }
        return xannotations;
    }

    public XAnnotationField<?>[] parseFields(Element annotationElement, Class<? extends Annotation> annotationClass) throws AnnotationElementParseException {
        Method[] methods = annotationClass.getMethods();
        HashMap fieldsMap = new HashMap();
        for (Method method : methods) {
            if (Annotation.class.equals(method.getDeclaringClass())) continue;
            String name = method.getName();
            Class<?> type = method.getReturnType();
            fieldsMap.put(name, type);
        }
        ArrayList fields = new ArrayList(fieldsMap.size());
        for (Map.Entry entry : fieldsMap.entrySet()) {
            String name = (String)entry.getKey();
            Class type = (Class)entry.getValue();
            try {
                XAnnotationField<?> field = this.parseField(annotationElement, name, type);
                if (field == null) continue;
                fields.add(field);
            }
            catch (AnnotationElementParseException aepex) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
            }
        }
        return fields.toArray(new XAnnotationField[fields.size()]);
    }

    public XAnnotationField<?>[] parseFields(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        Method[] methods = annotationClass.getMethods();
        ArrayList fields = new ArrayList(methods.length);
        for (Method method : methods) {
            if (Annotation.class.equals(method.getDeclaringClass())) continue;
            String name = method.getName();
            Class<?> type = method.getReturnType();
            try {
                fields.add(this.parseField(annotation, name, type));
            }
            catch (NoSuchAnnotationFieldException nsafex) {
                throw new AssertionError((Object)nsafex);
            }
        }
        return fields.toArray(new XAnnotationField[fields.size()]);
    }

    public XAnnotationField<?> parseField(Element annotationElement, String name, Class type) throws AnnotationElementParseException {
        XAnnotationField field = XAnnotationFieldParser.GENERIC.parse(annotationElement, name, type);
        return field;
    }

    public XAnnotationField<?> parseField(Annotation annotation, String name, Class type) throws NoSuchAnnotationFieldException {
        XAnnotationField field = XAnnotationFieldParser.GENERIC.parse(annotation, name, type);
        return field;
    }
}

