/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.reflect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jvnet.annox.reflect.AnnotatedElementException;
import org.jvnet.annox.reflect.AnnotatedElementFactory;
import org.jvnet.annox.reflect.DirectAnnotatedElementFactory;
import org.jvnet.annox.reflect.ParameterizedAnnotatedElement;
import org.jvnet.annox.reflect.ResourcedAnnotatedElementFactory;

public class DualAnnotatedElementFactory
implements AnnotatedElementFactory {
    private AnnotatedElementFactory primary;
    private AnnotatedElementFactory secondary;

    public DualAnnotatedElementFactory(AnnotatedElementFactory primary, AnnotatedElementFactory secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    public DualAnnotatedElementFactory() {
        this(new ResourcedAnnotatedElementFactory(), new DirectAnnotatedElementFactory());
    }

    public AnnotatedElement getAnnotatedElement(AnnotatedElement annotatedElement) throws AnnotatedElementException {
        AnnotatedElement primaryAnnotatedElement = this.primary.getAnnotatedElement(annotatedElement);
        if (primaryAnnotatedElement != null) {
            return primaryAnnotatedElement;
        }
        return this.secondary.getAnnotatedElement(annotatedElement);
    }

    public ParameterizedAnnotatedElement getAnnotatedElement(Constructor annotatedElement) throws AnnotatedElementException {
        ParameterizedAnnotatedElement primaryAnnotatedElement = this.primary.getAnnotatedElement(annotatedElement);
        if (primaryAnnotatedElement != null) {
            return primaryAnnotatedElement;
        }
        return this.secondary.getAnnotatedElement(annotatedElement);
    }

    public ParameterizedAnnotatedElement getAnnotatedElement(Method annotatedElement) throws AnnotatedElementException {
        ParameterizedAnnotatedElement primaryAnnotatedElement = this.primary.getAnnotatedElement(annotatedElement);
        if (primaryAnnotatedElement != null) {
            return primaryAnnotatedElement;
        }
        return this.secondary.getAnnotatedElement(annotatedElement);
    }
}

