/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.util;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    private static Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    private static Map<String, Class<?>> namePrimitiveMap;
    public static final String ARRAY_SUFFIX = "[]";
    public static final Class<?>[] EMPTY_CLASS_ARRAY;

    public static Class primitiveToWrapper(Class cls) {
        Validate.notNull((Object)cls);
        if (cls.isPrimitive()) {
            return primitiveWrapperMap.get(cls);
        }
        return cls;
    }

    public static Class wrapperToPrimitive(Class cls) {
        Validate.notNull((Object)cls);
        Class<?> primitiveClass = wrapperPrimitiveMap.get(cls);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        return cls;
    }

    public static Class nameToPrimitive(String name) {
        if (name == null) {
            return null;
        }
        return namePrimitiveMap.get(name);
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> forName(String className, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (className.endsWith(ARRAY_SUFFIX)) {
            String componentClassName = className.substring(0, className.length() - ARRAY_SUFFIX.length());
            return ClassUtils.getArrayClass(ClassUtils.forName(componentClassName, initialize, loader));
        }
        Class primitiveClass = ClassUtils.nameToPrimitive(className);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        return Class.forName(className, initialize, loader);
    }

    public static Class<?> getArrayClass(Class<?> componentClass) {
        Object componentArray = Array.newInstance(componentClass, 0);
        return componentArray.getClass();
    }

    public static Class<?>[] forNames(String names) throws ClassNotFoundException {
        return ClassUtils.forNames(names, true, null);
    }

    public static Class<?>[] forNames(String names, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        if (names == null) {
            return null;
        }
        String n = names.trim();
        if ("".equals(n)) {
            return EMPTY_CLASS_ARRAY;
        }
        String[] classNames = StringUtils.split((String)n, (char)',');
        Class[] classes = new Class[classNames.length];
        for (int index = 0; index < classNames.length; ++index) {
            classes[index] = ClassUtils.forName(classNames[index].trim(), initialize, loader);
        }
        return classes;
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        wrapperPrimitiveMap = new HashMap();
        wrapperPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperPrimitiveMap.put(Float.class, Float.TYPE);
        namePrimitiveMap = new HashMap(8);
        namePrimitiveMap.put("boolean", Boolean.TYPE);
        namePrimitiveMap.put("byte", Byte.TYPE);
        namePrimitiveMap.put("char", Character.TYPE);
        namePrimitiveMap.put("short", Short.TYPE);
        namePrimitiveMap.put("int", Integer.TYPE);
        namePrimitiveMap.put("long", Long.TYPE);
        namePrimitiveMap.put("double", Double.TYPE);
        namePrimitiveMap.put("float", Float.TYPE);
        EMPTY_CLASS_ARRAY = new Class[0];
    }
}

