/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.Validate;
import org.jvnet.annox.annotation.NoSuchAnnotationFieldException;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.model.XAnnotationField;
import org.jvnet.annox.parser.AnnotationElementParseException;
import org.jvnet.annox.parser.XAnnotationParser;
import org.jvnet.annox.util.AnnotationElementUtils;
import org.jvnet.annox.util.ClassUtils;
import org.jvnet.annox.util.ObjectUtils;
import org.jvnet.annox.util.ValueParseException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XAnnotationFieldParser<T, V> {
    public static final XBooleanFieldParser BOOLEAN = new XBooleanFieldParser();
    public static final XByteFieldParser BYTE = new XByteFieldParser();
    public static final XIntFieldParser INT = new XIntFieldParser();
    public static final XLongFieldParser LONG = new XLongFieldParser();
    public static final XShortFieldParser SHORT = new XShortFieldParser();
    public static final XCharFieldParser CHAR = new XCharFieldParser();
    public static final XClassFieldParser CLASS = new XClassFieldParser();
    public static final XDoubleFieldParser DOUBLE = new XDoubleFieldParser();
    public static final XFloatFieldParser FLOAT = new XFloatFieldParser();
    public static final XEnumFieldParser ENUM = new XEnumFieldParser();
    public static final XStringFieldParser STRING = new XStringFieldParser();
    public static final XAnnotationFieldParser ANNOTATION = new XAnnotationItemFieldParser();
    public static final XAnnotationFieldParser XANNOTATION = new XAnnotationXItemFieldParser();
    public static final XBooleanArrayFieldParser BOOLEAN_ARRAY = new XBooleanArrayFieldParser();
    public static final XByteArrayFieldParser BYTE_ARRAY = new XByteArrayFieldParser();
    public static final XIntArrayFieldParser INT_ARRAY = new XIntArrayFieldParser();
    public static final XLongArrayFieldParser LONG_ARRAY = new XLongArrayFieldParser();
    public static final XShortArrayFieldParser SHORT_ARRAY = new XShortArrayFieldParser();
    public static final XCharArrayFieldParser CHAR_ARRAY = new XCharArrayFieldParser();
    public static final XClassArrayFieldParser CLASS_ARRAY = new XClassArrayFieldParser();
    public static final XDoubleArrayFieldParser DOUBLE_ARRAY = new XDoubleArrayFieldParser();
    public static final XFloatArrayFieldParser FLOAT_ARRAY = new XFloatArrayFieldParser();
    public static final XEnumArrayFieldParser ENUM_ARRAY = new XEnumArrayFieldParser();
    public static final XStringArrayFieldParser STRING_ARRAY = new XStringArrayFieldParser();
    public static final XAnnotationItemArrayFieldParser ANNOTATION_ARRAY = new XAnnotationItemArrayFieldParser();
    public static final XAnnotationItemXArrayFieldParser XANNOTATION_ARRAY = new XAnnotationItemXArrayFieldParser();
    public static final XGenericFieldParser GENERIC = new XGenericFieldParser();

    public abstract XAnnotationField<T> parse(Element var1, String var2, Class<?> var3) throws AnnotationElementParseException;

    public abstract XAnnotationField<T> parse(Annotation var1, String var2, Class<?> var3) throws NoSuchAnnotationFieldException;

    public abstract XAnnotationField<T> construct(String var1, V var2, Class<?> var3);

    public <U> U getAnnotationFieldValue(Annotation annotation, String name) throws NoSuchAnnotationFieldException {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        try {
            Method method = annotationClass.getMethod(name, new Class[0]);
            Object value = method.invoke((Object)annotation, new Object[0]);
            return (U)value;
        }
        catch (NoSuchMethodException nsmex) {
            throw new NoSuchAnnotationFieldException(annotationClass, name, nsmex);
        }
        catch (IllegalAccessException iaex) {
            throw new AssertionError((Object)iaex);
        }
        catch (InvocationTargetException itex) {
            throw new AssertionError((Object)itex);
        }
    }

    public static XAnnotationFieldParser detectType(Class theClass) {
        if (theClass == null) {
            throw new IllegalArgumentException("Class must not be null.");
        }
        if (theClass.isArray()) {
            XAnnotationFieldParser componentType = XAnnotationFieldParser.detectType(theClass.getComponentType());
            if (componentType == BOOLEAN) {
                return BOOLEAN_ARRAY;
            }
            if (componentType == BYTE) {
                return BYTE_ARRAY;
            }
            if (componentType == INT) {
                return INT_ARRAY;
            }
            if (componentType == LONG) {
                return LONG_ARRAY;
            }
            if (componentType == SHORT) {
                return SHORT_ARRAY;
            }
            if (componentType == CHAR) {
                return CHAR_ARRAY;
            }
            if (componentType == CLASS) {
                return CLASS_ARRAY;
            }
            if (componentType == DOUBLE) {
                return DOUBLE_ARRAY;
            }
            if (componentType == FLOAT) {
                return FLOAT_ARRAY;
            }
            if (componentType == ENUM) {
                return ENUM_ARRAY;
            }
            if (componentType == STRING) {
                return STRING_ARRAY;
            }
            if (componentType == ANNOTATION) {
                return ANNOTATION_ARRAY;
            }
            if (componentType == XANNOTATION) {
                return XANNOTATION_ARRAY;
            }
            throw new IllegalArgumentException("Unknown annotation field type.");
        }
        if (Boolean.class.equals((Object)theClass) || Boolean.TYPE.equals(theClass)) {
            return BOOLEAN;
        }
        if (Byte.class.equals((Object)theClass) || Byte.TYPE.equals(theClass)) {
            return BYTE;
        }
        if (Integer.class.equals((Object)theClass) || Integer.TYPE.equals(theClass)) {
            return INT;
        }
        if (Long.class.equals((Object)theClass) || Long.TYPE.equals(theClass)) {
            return LONG;
        }
        if (Short.class.equals((Object)theClass) || Short.TYPE.equals(theClass)) {
            return SHORT;
        }
        if (Character.class.equals((Object)theClass) || Character.TYPE.equals(theClass)) {
            return CHAR;
        }
        if (Double.class.equals((Object)theClass) || Double.TYPE.equals(theClass)) {
            return DOUBLE;
        }
        if (Float.class.equals((Object)theClass) || Float.TYPE.equals(theClass)) {
            return FLOAT;
        }
        if (Class.class.equals((Object)theClass)) {
            return CLASS;
        }
        if (String.class.equals((Object)theClass)) {
            return STRING;
        }
        if (Enum.class.isAssignableFrom(theClass)) {
            return ENUM;
        }
        if (Annotation.class.isAssignableFrom(theClass)) {
            return ANNOTATION;
        }
        if (XAnnotation.class.isAssignableFrom(theClass)) {
            return XANNOTATION;
        }
        throw new IllegalArgumentException("Unknown annotation field type [" + theClass.getName() + "].");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XGenericFieldParser<T, V>
    extends XAnnotationFieldParser<T, V> {
        @Override
        public XAnnotationField<T> parse(Element element, String name, Class<?> type) throws AnnotationElementParseException {
            XAnnotationFieldParser parser = XGenericFieldParser.detectType(type);
            return parser.parse(element, name, type);
        }

        @Override
        public XAnnotationField<T> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
            XAnnotationFieldParser parser = XGenericFieldParser.detectType(type);
            return parser.parse(annotation, name, type);
        }

        @Override
        public XAnnotationField<T> construct(String name, V value, Class<?> type) {
            XAnnotationFieldParser parser = XGenericFieldParser.detectType(type);
            return parser.construct(name, value, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XAnnotationItemXArrayFieldParser
    extends XAnnotationFieldParser<XAnnotation[], XAnnotation[]> {
        @Override
        public XAnnotationField<XAnnotation[]> parse(Element annotationElement, String name, Class<?> type) throws AnnotationElementParseException {
            Element[] elements = AnnotationElementUtils.getFieldElements(annotationElement, name);
            XAnnotation[] annotations = new XAnnotation[elements.length];
            for (int index = 0; index < elements.length; ++index) {
                try {
                    annotations[index] = XAnnotationParser.GENERIC.parse(elements[index]);
                    continue;
                }
                catch (AnnotationElementParseException aepex) {
                    throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
                }
            }
            return new XAnnotationField.XAnnotationArray(name, annotations, type.getComponentType());
        }

        @Override
        public XAnnotationField<XAnnotation[]> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
            Annotation[] value = (Annotation[])this.getAnnotationFieldValue(annotation, name);
            XAnnotation[] annotations = new XAnnotation[value.length];
            for (int index = 0; index < value.length; ++index) {
                annotations[index] = XAnnotationParser.GENERIC.parse(value[index]);
            }
            return new XAnnotationField.XAnnotationArray(name, annotations, type.getComponentType());
        }

        @Override
        public XAnnotationField<XAnnotation[]> construct(String name, XAnnotation[] annotations, Class<?> type) {
            if (annotations.length == 0) {
                throw new IllegalArgumentException("Could not create an annotation array field from the empty xannotation array.");
            }
            Class<? extends Annotation> annotationClass = annotations[0].getAnnotationClass();
            for (XAnnotation annotation : annotations) {
                if (annotationClass.equals(annotation.getAnnotationClass())) continue;
                throw new IllegalArgumentException("All of the xannotations in the xannotation array must have the same annotation classe.");
            }
            XAnnotation[] xannotations = new XAnnotation[annotations.length];
            for (int index = 0; index < xannotations.length; ++index) {
                xannotations[index] = annotations[index];
            }
            return new XAnnotationField.XAnnotationArray(name, xannotations, annotationClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XAnnotationItemArrayFieldParser
    extends XAnnotationFieldParser<XAnnotation[], Annotation[]> {
        @Override
        public XAnnotationField<XAnnotation[]> parse(Element annotationElement, String name, Class<?> type) throws AnnotationElementParseException {
            Element[] elements = AnnotationElementUtils.getFieldElements(annotationElement, name);
            XAnnotation[] annotations = new XAnnotation[elements.length];
            for (int index = 0; index < elements.length; ++index) {
                try {
                    annotations[index] = XAnnotationParser.GENERIC.parse(elements[index]);
                    continue;
                }
                catch (AnnotationElementParseException aepex) {
                    throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
                }
            }
            return new XAnnotationField.XAnnotationArray(name, annotations, type.getComponentType());
        }

        @Override
        public XAnnotationField<XAnnotation[]> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
            Annotation[] value = (Annotation[])this.getAnnotationFieldValue(annotation, name);
            XAnnotation[] annotations = new XAnnotation[value.length];
            for (int index = 0; index < value.length; ++index) {
                annotations[index] = XAnnotationParser.GENERIC.parse(value[index]);
            }
            return new XAnnotationField.XAnnotationArray(name, annotations, type.getComponentType());
        }

        @Override
        public XAnnotationField<XAnnotation[]> construct(String name, Annotation[] annotations, Class<?> type) {
            XAnnotation[] xannotations = new XAnnotation[annotations.length];
            for (int index = 0; index < xannotations.length; ++index) {
                xannotations[index] = XAnnotationParser.GENERIC.parse(annotations[index]);
            }
            return new XAnnotationField.XAnnotationArray(name, xannotations, type.getComponentType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XEnumArrayFieldParser
    extends XArrayFieldParser<Enum, Enum> {
        @Override
        public XAnnotationField<Enum[]> construct(String name, Enum[] value, Class<?> type) {
            return new XAnnotationField.XEnumArray(name, value, type.getComponentType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XStringArrayFieldParser
    extends XArrayFieldParser<String, String> {
        @Override
        public XAnnotationField<String[]> construct(String name, String[] value, Class<?> type) {
            return new XAnnotationField.XStringArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XFloatArrayFieldParser
    extends XArrayFieldParser<Float, Float> {
        @Override
        public XAnnotationField<Float[]> construct(String name, Float[] value, Class<?> type) {
            return new XAnnotationField.XFloatArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XDoubleArrayFieldParser
    extends XArrayFieldParser<Double, Double> {
        @Override
        public XAnnotationField<Double[]> construct(String name, Double[] value, Class<?> type) {
            return new XAnnotationField.XDoubleArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XClassArrayFieldParser
    extends XArrayFieldParser<Class, Object> {
        @Override
        public Object[] parse(String[] draft, Class<?> type) throws ValueParseException {
            try {
                return super.parse(draft, type);
            }
            catch (ValueParseException ex) {
                return draft;
            }
        }

        @Override
        public XAnnotationField<Class[]> construct(String name, Object[] value, Class<?> type) {
            if (value instanceof Class[]) {
                return new XAnnotationField.XClassArray(name, (Class[])value);
            }
            if (value instanceof String[]) {
                return new XAnnotationField.XClassArray(name, (String[])value);
            }
            throw new IllegalArgumentException("Unexpected value [" + value + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCharArrayFieldParser
    extends XArrayFieldParser<Character, Character> {
        @Override
        public XAnnotationField<Character[]> construct(String name, Character[] value, Class<?> type) {
            return new XAnnotationField.XCharArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XShortArrayFieldParser
    extends XArrayFieldParser<Short, Short> {
        @Override
        public XAnnotationField<Short[]> construct(String name, Short[] value, Class<?> type) {
            return new XAnnotationField.XShortArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XLongArrayFieldParser
    extends XArrayFieldParser<Long, Long> {
        @Override
        public XAnnotationField<Long[]> construct(String name, Long[] value, Class<?> type) {
            return new XAnnotationField.XLongArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XIntArrayFieldParser
    extends XArrayFieldParser<Integer, Integer> {
        @Override
        public XAnnotationField<Integer[]> construct(String name, Integer[] value, Class<?> type) {
            return new XAnnotationField.XIntArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XByteArrayFieldParser
    extends XArrayFieldParser<Byte, Byte> {
        @Override
        public XAnnotationField<Byte[]> construct(String name, Byte[] value, Class<?> type) {
            return new XAnnotationField.XByteArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XBooleanArrayFieldParser
    extends XArrayFieldParser<Boolean, Boolean> {
        @Override
        public XAnnotationField<Boolean[]> construct(String name, Boolean[] value, Class<?> type) {
            return new XAnnotationField.XBooleanArray(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XAnnotationXItemFieldParser
    extends XAnnotationFieldParser<XAnnotation, XAnnotation> {
        @Override
        public XAnnotationField<XAnnotation> parse(Element annotationElement, String name, Class<?> type) throws AnnotationElementParseException {
            Element element = AnnotationElementUtils.getFieldElement(annotationElement, name);
            if (element == null) {
                return null;
            }
            try {
                XAnnotation xannotation = XAnnotationParser.GENERIC.parse(element);
                return new XAnnotationField.XAnnotation(name, xannotation, type);
            }
            catch (AnnotationElementParseException aepex) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
            }
        }

        @Override
        public XAnnotationField<XAnnotation> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
            Annotation value = (Annotation)this.getAnnotationFieldValue(annotation, name);
            XAnnotation xannotation = XAnnotationParser.GENERIC.parse(value);
            Class<?> annotationType = type;
            return new XAnnotationField.XAnnotation(name, xannotation, annotationType);
        }

        @Override
        public XAnnotationField<XAnnotation> construct(String name, XAnnotation annotation, Class<?> type) {
            return new XAnnotationField.XAnnotation(name, annotation, annotation.getAnnotationClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XAnnotationItemFieldParser
    extends XAnnotationFieldParser<XAnnotation, Annotation> {
        @Override
        public XAnnotationField<XAnnotation> parse(Element annotationElement, String name, Class<?> type) throws AnnotationElementParseException {
            Element element = AnnotationElementUtils.getFieldElement(annotationElement, name);
            if (element == null) {
                return null;
            }
            try {
                XAnnotation xannotation = XAnnotationParser.GENERIC.parse(element);
                return new XAnnotationField.XAnnotation(name, xannotation, type);
            }
            catch (AnnotationElementParseException aepex) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
            }
        }

        @Override
        public XAnnotationField<XAnnotation> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
            Annotation value = (Annotation)this.getAnnotationFieldValue(annotation, name);
            XAnnotation xannotation = XAnnotationParser.GENERIC.parse(value);
            Class<?> annotationType = type;
            return new XAnnotationField.XAnnotation(name, xannotation, annotationType);
        }

        @Override
        public XAnnotationField<XAnnotation> construct(String name, Annotation annotation, Class<?> type) {
            XAnnotation xannotation = XAnnotationParser.GENERIC.parse(annotation);
            return new XAnnotationField.XAnnotation(name, xannotation, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XEnumFieldParser
    extends XFieldParser<Enum, Enum> {
        @Override
        public XAnnotationField<Enum> construct(String name, Enum value, Class<?> type) {
            return new XAnnotationField.XEnum(name, value, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XStringFieldParser
    extends XFieldParser<String, String> {
        @Override
        public XAnnotationField<String> construct(String name, String value, Class<?> type) {
            return new XAnnotationField.XString(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XFloatFieldParser
    extends XFieldParser<Float, Float> {
        @Override
        public XAnnotationField<Float> construct(String name, Float value, Class<?> type) {
            return new XAnnotationField.XFloat(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XDoubleFieldParser
    extends XFieldParser<Double, Double> {
        @Override
        public XAnnotationField<Double> construct(String name, Double value, Class<?> type) {
            return new XAnnotationField.XDouble(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XClassFieldParser
    extends XFieldParser<Class, Object> {
        @Override
        public XAnnotationField<Class> construct(String name, Object value, Class<?> type) {
            if (value instanceof Class) {
                return new XAnnotationField.XClass(name, (Class)value);
            }
            if (value instanceof String) {
                return new XAnnotationField.XClass(name, (String)value);
            }
            throw new IllegalArgumentException("Unexpected value [" + value + "].");
        }

        @Override
        public Object parse(String draft, Class<?> type) {
            try {
                return super.parse(draft, type);
            }
            catch (ValueParseException vpex) {
                return draft;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCharFieldParser
    extends XFieldParser<Character, Character> {
        @Override
        public XAnnotationField<Character> construct(String name, Character value, Class<?> type) {
            return new XAnnotationField.XChar(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XShortFieldParser
    extends XFieldParser<Short, Short> {
        @Override
        public XAnnotationField<Short> construct(String name, Short value, Class<?> type) {
            return new XAnnotationField.XShort(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XLongFieldParser
    extends XFieldParser<Long, Long> {
        @Override
        public XAnnotationField<Long> construct(String name, Long value, Class<?> type) {
            return new XAnnotationField.XLong(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XIntFieldParser
    extends XFieldParser<Integer, Integer> {
        @Override
        public XAnnotationField<Integer> construct(String name, Integer value, Class<?> type) {
            return new XAnnotationField.XInt(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XByteFieldParser
    extends XFieldParser<Byte, Byte> {
        @Override
        public XAnnotationField<Byte> construct(String name, Byte value, Class<?> type) {
            return new XAnnotationField.XByte(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XBooleanFieldParser
    extends XFieldParser<Boolean, Boolean> {
        @Override
        public XAnnotationField<Boolean> construct(String name, Boolean value, Class<?> type) {
            return new XAnnotationField.XBoolean(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class XArrayFieldParser<T, V>
    extends XAnnotationFieldParser<T[], V[]> {
        @Override
        public XAnnotationField<T[]> parse(Element element, String name, Class<?> type) throws AnnotationElementParseException {
            String[] draft = AnnotationElementUtils.getFieldValues(element, name);
            try {
                V[] value = this.parse(draft, type.getComponentType());
                return this.construct(name, value, type);
            }
            catch (ValueParseException vpex) {
                throw new AnnotationElementParseException(element, (Throwable)vpex);
            }
        }

        @Override
        public XAnnotationField<T[]> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
            Object values = this.getAnnotationFieldValue(annotation, name);
            int length = Array.getLength(values);
            Object[] value = (Object[])Array.newInstance(ClassUtils.primitiveToWrapper(type.getComponentType()), length);
            for (int index = 0; index < length; ++index) {
                Object object;
                value[index] = object = Array.get(values, index);
            }
            return this.construct(name, value, type);
        }

        @Override
        public abstract XAnnotationField<T[]> construct(String var1, V[] var2, Class<?> var3);

        public V[] parse(String[] draft, Class<?> type) throws ValueParseException {
            try {
                return ObjectUtils.valueOf(type, draft);
            }
            catch (ClassNotFoundException cnfex) {
                throw new ValueParseException(draft, type, cnfex);
            }
            catch (IllegalArgumentException iaex) {
                throw new ValueParseException(draft, type, iaex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class XFieldParser<T, V>
    extends XAnnotationFieldParser<T, V> {
        @Override
        public XAnnotationField<T> parse(Element element, String name, Class<?> type) throws AnnotationElementParseException {
            Validate.notNull((Object)element, (String)"Element must not be null.");
            Validate.notNull((Object)name, (String)"Field name must not be null.");
            Validate.notNull(type, (String)"Type must not be null.");
            String draft = AnnotationElementUtils.getFieldValue(element, name);
            if (draft == null) {
                return null;
            }
            try {
                V value = this.parse(draft, type);
                return this.construct(name, value, type);
            }
            catch (ValueParseException vpex) {
                throw new AnnotationElementParseException(element, (Throwable)vpex);
            }
        }

        @Override
        public XAnnotationField<T> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
            Object value = this.getAnnotationFieldValue(annotation, name);
            return this.construct(name, value, type);
        }

        public V parse(String draft, Class<?> type) throws ValueParseException {
            try {
                return (V)ObjectUtils.valueOf(type, draft);
            }
            catch (ClassNotFoundException cnfex) {
                throw new ValueParseException(draft, type, cnfex);
            }
            catch (IllegalArgumentException iaex) {
                throw new ValueParseException(draft, type, iaex);
            }
        }

        @Override
        public abstract XAnnotationField<T> construct(String var1, V var2, Class<?> var3);
    }
}

