/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.annox.reflect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang.Validate;
import org.jvnet.annox.reader.XReader;
import org.jvnet.annox.reader.resourced.ResourcedXReader;
import org.jvnet.annox.reflect.AnnotatedElementException;
import org.jvnet.annox.reflect.AnnotatedElementFactory;
import org.jvnet.annox.reflect.ParameterizedAnnotatedElement;

public class ResourcedAnnotatedElementFactory
implements AnnotatedElementFactory {
    private final XReader xreader;

    public ResourcedAnnotatedElementFactory(XReader xreader) {
        Validate.notNull((Object)xreader);
        this.xreader = xreader;
    }

    public ResourcedAnnotatedElementFactory() {
        this(new ResourcedXReader());
    }

    public XReader getXReader() {
        return this.xreader;
    }

    public AnnotatedElement getAnnotatedElement(AnnotatedElement annotatedElement) throws AnnotatedElementException {
        Validate.notNull((Object)annotatedElement);
        if (annotatedElement instanceof Package) {
            return this.getXReader().getXPackage((Package)annotatedElement);
        }
        if (annotatedElement instanceof Class) {
            return this.getXReader().getXClass((Class)annotatedElement);
        }
        if (annotatedElement instanceof Field) {
            return this.getXReader().getXField((Field)annotatedElement);
        }
        if (annotatedElement instanceof Constructor) {
            return this.getXReader().getXConstructor((Constructor)annotatedElement);
        }
        if (annotatedElement instanceof Method) {
            return this.getXReader().getXMethod((Method)annotatedElement);
        }
        throw new AssertionError((Object)("Unexpected annotated element [" + annotatedElement + "]"));
    }

    public ParameterizedAnnotatedElement getAnnotatedElement(Constructor constructor) throws AnnotatedElementException {
        Validate.notNull((Object)constructor);
        return this.getXReader().getXConstructor(constructor);
    }

    public ParameterizedAnnotatedElement getAnnotatedElement(Method method) throws AnnotatedElementException {
        Validate.notNull((Object)method);
        return this.getXReader().getXMethod(method);
    }
}

