package org.jvnet.hifaces.demo.facelets.web;

import java.io.IOException;

import javax.faces.application.ViewHandler;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;

import org.jvnet.hifaces.util.OutputUtils;
import org.jvnet.hifaces.util.PanelUtils;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletFactory;

public class FaceletsBean {

	private HtmlPanelGroup component;

	public HtmlPanelGroup createComponent() {
		final HtmlPanelGroup component = PanelUtils.createPanelGroup();
		final HtmlOutputText text = OutputUtils.createStaticOutputText("test");
		final FacesContext facesContext = FacesContext.getCurrentInstance();
		final ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
		
		final FaceletFactory factory = FaceletFactory.getInstance();
		try {
			final Facelet facelet = factory
					.getFacelet("/classlets/org/jvnet/hifaces/demo/facelets/web/Test.xhtml");
			
			
			facelet.apply(facesContext, component);
		} catch (IOException ignored) {
			// nothing to do
		}
		return component;

	}

	public HtmlPanelGroup getComponent() {
		if (component == null) {
			component = createComponent();
		}
		return component;
	}

	public void setComponent(HtmlPanelGroup component) {
		this.component = component;
	}
}
