/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hifaces.myfaces.custom.updateactionlistener.tag;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentConfig;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.updateactionlistener.UpdateActionListener;

public class UpdateActionListenerHandler
extends TagHandler {
    private static Log logger = LogFactory.getLog(UpdateActionListenerHandler.class);
    private TagAttribute converterAttr;
    private TagAttribute propertyAttr;
    private TagAttribute valueAttr = this.getRequiredAttribute("value");

    public UpdateActionListenerHandler(ComponentConfig config) {
        this((TagConfig)config);
    }

    public UpdateActionListenerHandler(TagConfig config) {
        super(config);
        this.propertyAttr = this.getRequiredAttribute("property");
        this.converterAttr = this.getAttribute("converter");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        logger.debug((Object)("Apply called. Component: " + parent));
        ActionSource actionSource = (ActionSource)parent;
        if (this.sourceHasProperty(actionSource)) {
            return;
        }
        UpdateActionListener al = new UpdateActionListener();
        if (this.converterAttr != null) {
            al.setConverter((Converter)this.converterAttr.getObject(ctx));
        }
        Application app = ctx.getFacesContext().getApplication();
        ValueBinding vb = app.createValueBinding(this.valueAttr.getValue());
        al.setValueBinding(vb);
        vb = app.createValueBinding(this.propertyAttr.getValue());
        al.setPropertyBinding(vb);
        actionSource.addActionListener((ActionListener)al);
    }

    private boolean sourceHasProperty(ActionSource source) {
        for (ActionListener listener : source.getActionListeners()) {
            UpdateActionListener al;
            if (!(listener instanceof UpdateActionListener) || !(al = (UpdateActionListener)listener).getPropertyBinding().getExpressionString().equals(this.propertyAttr.getValue())) continue;
            logger.debug((Object)("Action listener already has a listener for " + this.propertyAttr.getValue()));
            return true;
        }
        logger.debug((Object)("Action listener for property is not present. Property: " + this.propertyAttr.getValue()));
        return false;
    }
}

