/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.annotation_indexer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jvnet.hudson.annotation_indexer.Indexed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"*"})
public class AnnotationProcessorImpl
extends AbstractProcessor {
    private Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        HashMap<String, Use> output = new HashMap<String, Use>();
        this.scan(annotations, roundEnv, output);
        for (Use u : output.values()) {
            u.write();
        }
        return false;
    }

    private AnnotationMirror findAnnotationOn(Element e, String name) {
        for (AnnotationMirror annotationMirror : this.getElementUtils().getAllAnnotationMirrors(e)) {
            if (!this.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(name)) continue;
            return annotationMirror;
        }
        return null;
    }

    private void scan(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<String, Use> output) {
        for (TypeElement typeElement : annotations) {
            AnnotationMirror indexed = this.findAnnotationOn(typeElement, Indexed.class.getName());
            if (indexed == null) continue;
            String annName = this.getElementUtils().getBinaryName(typeElement).toString();
            Use o = output.get(annName);
            if (o == null) {
                o = new Use(annName);
                output.put(annName, o);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                AnnotationMirror marked = this.findAnnotationOn(element, annName);
                assert (marked != null);
                o.add(element);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Use {
        final String annotationName;
        final Set<String> classes = new TreeSet<String>();
        final Set<Element> originatingElements = new HashSet<Element>();

        private Use(String annotationName) {
            this.annotationName = annotationName;
        }

        void add(Element elt) {
            TypeElement t;
            this.originatingElements.add(elt);
            switch (elt.getKind()) {
                case CLASS: {
                    t = (TypeElement)elt;
                    break;
                }
                case METHOD: 
                case FIELD: {
                    t = (TypeElement)elt.getEnclosingElement();
                    break;
                }
                default: {
                    throw new AssertionError((Object)elt.getKind());
                }
            }
            this.classes.add(AnnotationProcessorImpl.this.getElementUtils().getBinaryName(t).toString());
        }

        String getIndexFileName() {
            return "META-INF/annotations/" + this.annotationName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<String> loadExisting() throws IOException {
            ArrayList<String> elements = new ArrayList<String>();
            try {
                FileObject in = AnnotationProcessorImpl.this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.getIndexFileName());
                BufferedReader is = new BufferedReader(new InputStreamReader(in.openInputStream(), "UTF-8"));
                try {
                    String line;
                    while ((line = is.readLine()) != null) {
                        elements.add(line);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write() {
            try {
                FileObject out = AnnotationProcessorImpl.this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", this.getIndexFileName(), this.originatingElements.toArray(new Element[this.originatingElements.size()]));
                PrintWriter w = new PrintWriter(new OutputStreamWriter(out.openOutputStream(), "UTF-8"));
                try {
                    for (String el : this.classes) {
                        w.println(el);
                    }
                }
                finally {
                    w.close();
                }
            }
            catch (IOException x) {
                AnnotationProcessorImpl.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
            }
        }
    }
}

