/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.jelly.LocationAware;

public class JellyException
extends Exception
implements LocationAware {
    private Throwable cause;
    private String fileName;
    private String elementName;
    private int lineNumber = -1;
    private int columnNumber = -1;
    static /* synthetic */ Class class$java$lang$Throwable;

    public JellyException() {
    }

    public JellyException(String message) {
        super(message);
    }

    public JellyException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public JellyException(Throwable cause) {
        super(cause.getLocalizedMessage());
        this.cause = cause;
    }

    public JellyException(Throwable cause, String fileName, String elementName, int columnNumber, int lineNumber) {
        this(cause.getLocalizedMessage(), cause, fileName, elementName, columnNumber, lineNumber);
    }

    public JellyException(String reason, Throwable cause, String fileName, String elementName, int columnNumber, int lineNumber) {
        super(reason == null ? cause.getClass().getName() : reason);
        this.cause = cause;
        this.fileName = fileName;
        this.elementName = elementName;
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
    }

    public JellyException(String reason, String fileName, String elementName, int columnNumber, int lineNumber) {
        super(reason);
        this.fileName = fileName;
        this.elementName = elementName;
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getMessage() {
        if (this.fileName == null && this.lineNumber == -1 && this.columnNumber == -1 && this.elementName == null) {
            return this.getReason();
        }
        return this.fileName + ":" + this.lineNumber + ":" + this.columnNumber + ": <" + this.elementName + "> " + this.getReason();
    }

    public String getReason() {
        return super.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            if (this.cause != null && !this.isChainingSupported()) {
                s.println("Root cause");
                this.cause.printStackTrace(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (this.cause != null && !this.isChainingSupported()) {
                s.println("Root cause");
                this.cause.printStackTrace(s);
            }
        }
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.cause != null && !this.isChainingSupported()) {
            System.out.println("Root cause");
            this.cause.printStackTrace();
        }
    }

    private boolean isChainingSupported() {
        try {
            (class$java$lang$Throwable == null ? (class$java$lang$Throwable = JellyException.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getCause", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

