/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import org.apache.commons.jelly.DynaTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StaticTag
extends DynaTagSupport {
    private String uri;
    private String qname;
    private String localName;
    private AttributesImpl attributes = new AttributesImpl();

    public StaticTag() {
    }

    public StaticTag(String uri, String localName, String qname) {
        this.uri = uri;
        this.localName = localName;
        this.qname = qname;
    }

    public String toString() {
        return super.toString() + "[qname=" + this.qname + ";attributes=" + this.attributes + "]";
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        try {
            output.startElement(this.uri, this.localName, this.qname, this.attributes);
            this.invokeBody(output);
            output.endElement(this.uri, this.localName, this.qname);
        }
        catch (SAXException e) {
            throw new JellyTagException(e);
        }
        finally {
            this.attributes.clear();
        }
    }

    public void setAttribute(String name, String prefix, String nsURI, Object value) {
        if (value == null) {
            return;
        }
        if (prefix != null && prefix.length() > 0) {
            this.attributes.addAttribute(nsURI, name, prefix + ":" + name, "CDATA", value.toString());
        } else {
            this.attributes.addAttribute("", name, name, "CDATA", value.toString());
        }
    }

    public void setAttribute(String name, Object value) throws JellyTagException {
        int index = this.attributes.getIndex("", name);
        if (index >= 0) {
            this.attributes.removeAttribute(index);
        }
        if (value != null) {
            this.attributes.addAttribute("", name, name, "CDATA", value.toString());
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getQName() {
        return this.qname;
    }

    public void setQName(String qname) {
        this.qname = qname;
        int idx = qname.indexOf(58);
        this.localName = idx >= 0 ? qname.substring(idx + 1) : qname;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
        if (this.qname == null || !this.qname.endsWith(localName)) {
            localName = this.qname;
        }
    }
}

