/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertingWrapDynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.jelly.CompilableTag;
import org.apache.commons.jelly.DynaTag;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.LocationAware;
import org.apache.commons.jelly.NamespaceAwareTag;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.DefaultTagFactory;
import org.apache.commons.jelly.impl.ExpressionAttribute;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TagScript
implements Script {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$impl$TagScript == null ? (class$org$apache$commons$jelly$impl$TagScript = TagScript.class$("org.apache.commons.jelly.impl.TagScript")) : class$org$apache$commons$jelly$impl$TagScript));
    protected Map attributes = new Hashtable();
    private Map tagNamespacesMap;
    private Map namespaceContext;
    private String fileName;
    private String elementName;
    private String localName;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private TagFactory tagFactory;
    private Script tagBody;
    private TagScript parent;
    private Attributes saxAttributes;
    private URL scriptURL = null;
    private Map threadLocalTagCache = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$org$apache$commons$jelly$impl$TagScript;
    static /* synthetic */ Class class$org$apache$commons$jelly$expression$Expression;
    static /* synthetic */ Class class$java$lang$Object;

    public static TagScript newInstance(Class tagClass) {
        DefaultTagFactory factory = new DefaultTagFactory(tagClass);
        return new TagScript(factory);
    }

    public TagScript() {
    }

    public TagScript(TagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public String toString() {
        return super.toString() + "[tag=" + this.elementName + ";at=" + this.lineNumber + ":" + this.columnNumber + "]";
    }

    public Script compile() throws JellyException {
        if (this.tagBody != null) {
            this.tagBody = this.tagBody.compile();
        }
        return this;
    }

    public void setTagNamespacesMap(Map tagNamespacesMap) {
        if (!(tagNamespacesMap instanceof Hashtable)) {
            tagNamespacesMap = new Hashtable(tagNamespacesMap);
        }
        this.tagNamespacesMap = tagNamespacesMap;
    }

    public void setLocator(Locator locator) {
        this.setLineNumber(locator.getLineNumber());
        this.setColumnNumber(locator.getColumnNumber());
    }

    public void addAttribute(String name, Expression expression) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding attribute name: " + name + " expression: " + expression));
        }
        this.attributes.put(name, new ExpressionAttribute(name, expression));
    }

    public void addAttribute(String name, String prefix, String nsURI, Expression expression) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding attribute name: " + name + " expression: " + expression));
        }
        if (name.indexOf(58) == -1) {
            name = prefix + ':' + name;
        }
        this.attributes.put(name, new ExpressionAttribute(name, prefix, nsURI, expression));
    }

    private URL getJellyContextURL(URL url) throws MalformedURLException {
        String text = url.toString();
        int idx = text.lastIndexOf(47);
        text = text.substring(0, idx + 1);
        return new URL(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(JellyContext context, XMLOutput output) throws JellyTagException {
        URL rootURL = context.getRootURL();
        URL currentURL = context.getCurrentURL();
        if (!context.isCacheTags()) {
            this.clearTag();
        }
        try {
            Tag tag = this.getTag(context);
            if (tag == null) {
                return;
            }
            tag.setContext(context);
            this.setContextURLs(context);
            if (tag instanceof DynaTag) {
                DynaTag dynaTag = (DynaTag)tag;
                Iterator iter = this.attributes.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String name = (String)entry.getKey();
                    Expression expression = ((ExpressionAttribute)entry.getValue()).exp;
                    Class type = dynaTag.getAttributeType(name);
                    Object value = null;
                    value = type != null && type.isAssignableFrom(class$org$apache$commons$jelly$expression$Expression == null ? TagScript.class$("org.apache.commons.jelly.expression.Expression") : class$org$apache$commons$jelly$expression$Expression) && !type.isAssignableFrom(class$java$lang$Object == null ? TagScript.class$("java.lang.Object") : class$java$lang$Object) ? expression : expression.evaluateRecurse(context);
                    dynaTag.setAttribute(name, value);
                }
            } else {
                ConvertingWrapDynaBean dynaBean = new ConvertingWrapDynaBean((Object)tag);
                Iterator iter = this.attributes.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String name = (String)entry.getKey();
                    Expression expression = ((ExpressionAttribute)entry.getValue()).exp;
                    DynaProperty property = dynaBean.getDynaClass().getDynaProperty(name);
                    if (property == null) {
                        throw new JellyException("This tag does not understand the '" + name + "' attribute");
                    }
                    Class type = property.getType();
                    Object value = null;
                    value = type.isAssignableFrom(class$org$apache$commons$jelly$expression$Expression == null ? TagScript.class$("org.apache.commons.jelly.expression.Expression") : class$org$apache$commons$jelly$expression$Expression) && !type.isAssignableFrom(class$java$lang$Object == null ? TagScript.class$("java.lang.Object") : class$java$lang$Object) ? expression : expression.evaluateRecurse(context);
                    dynaBean.set(name, value);
                }
            }
            tag.doTag(output);
            if (output != null) {
                output.flush();
            }
        }
        catch (JellyTagException e) {
            this.handleException(e);
        }
        catch (JellyException e) {
            this.handleException(e);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (RuntimeException e) {
            this.handleException(e);
        }
        catch (Error e) {
            this.handleException(e);
        }
        finally {
            context.setRootURL(rootURL);
            context.setCurrentURL(currentURL);
        }
    }

    protected void setContextURLs(JellyContext context) throws JellyTagException {
        if (this.scriptURL == null) {
            return;
        }
        if (context.getRootURL() == null) {
            context.setRootURL(this.scriptURL);
        }
        context.setCurrentURL(this.scriptURL);
    }

    public Tag getTag(JellyContext context) throws JellyException {
        Thread t = Thread.currentThread();
        Tag tag = (Tag)this.threadLocalTagCache.get(t);
        if (tag == null && (tag = this.createTag()) != null) {
            this.threadLocalTagCache.put(t, tag);
            this.configureTag(tag, context);
        }
        return tag;
    }

    public TagFactory getTagFactory() {
        return this.tagFactory;
    }

    public void setTagFactory(TagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public TagScript getParent() {
        return this.parent;
    }

    public Script getTagBody() {
        return this.tagBody;
    }

    public void setParent(TagScript parent) {
        this.parent = parent;
    }

    public void setTagBody(Script tagBody) {
        this.tagBody = tagBody;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        try {
            this.scriptURL = this.getJellyContextURL(new URL(fileName));
        }
        catch (MalformedURLException e) {
            log.debug((Object)"error setting script url", (Throwable)e);
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public Attributes getSaxAttributes() {
        return this.saxAttributes;
    }

    public void setSaxAttributes(Attributes saxAttributes) {
        this.saxAttributes = saxAttributes;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public synchronized Map getNamespaceContext() {
        if (this.namespaceContext == null) {
            if (this.parent != null) {
                this.namespaceContext = this.getParent().getNamespaceContext();
                if (this.tagNamespacesMap != null && !this.tagNamespacesMap.isEmpty()) {
                    Hashtable newContext = new Hashtable(this.namespaceContext.size() + 1);
                    newContext.putAll(this.namespaceContext);
                    newContext.putAll(this.tagNamespacesMap);
                    this.namespaceContext = newContext;
                }
            } else {
                this.namespaceContext = this.tagNamespacesMap;
                if (this.namespaceContext == null) {
                    this.namespaceContext = new Hashtable();
                }
            }
        }
        return this.namespaceContext;
    }

    protected Tag createTag() throws JellyException {
        if (this.tagFactory != null) {
            return this.tagFactory.createTag(this.localName, this.getSaxAttributes());
        }
        return null;
    }

    protected void configureTag(Tag tag, JellyContext context) throws JellyException {
        if (tag instanceof CompilableTag) {
            ((CompilableTag)((Object)tag)).compile();
        }
        Tag parentTag = null;
        if (this.parent != null) {
            parentTag = this.parent.getTag(context);
        }
        tag.setParent(parentTag);
        tag.setBody(this.tagBody);
        if (tag instanceof NamespaceAwareTag) {
            NamespaceAwareTag naTag = (NamespaceAwareTag)tag;
            naTag.setNamespaceContext(this.getNamespaceContext());
        }
        if (tag instanceof LocationAware) {
            this.applyLocation((LocationAware)((Object)tag));
        }
    }

    protected void clearTag() {
        Thread t = Thread.currentThread();
        this.threadLocalTagCache.put(t, null);
    }

    protected void setTag(Tag tag, JellyContext context) {
        Thread t = Thread.currentThread();
        this.threadLocalTagCache.put(t, tag);
    }

    protected void startNamespacePrefixes(XMLOutput output) throws SAXException {
        if (this.tagNamespacesMap != null) {
            Iterator iter = this.tagNamespacesMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String prefix = (String)entry.getKey();
                String uri = (String)entry.getValue();
                output.startPrefixMapping(prefix, uri);
            }
        }
    }

    protected void endNamespacePrefixes(XMLOutput output) throws SAXException {
        if (this.tagNamespacesMap != null) {
            Iterator iter = this.tagNamespacesMap.keySet().iterator();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                output.endPrefixMapping(prefix);
            }
        }
    }

    protected Object convertType(Object value, Class requiredType) throws JellyException {
        if (requiredType.isInstance(value)) {
            return value;
        }
        if (value instanceof String) {
            return ConvertUtils.convert((String)((String)value), (Class)requiredType);
        }
        return value;
    }

    protected JellyException createJellyException(String reason) {
        return new JellyException(reason, this.fileName, this.elementName, this.columnNumber, this.lineNumber);
    }

    protected JellyException createJellyException(String reason, Exception cause) {
        if (cause instanceof JellyException) {
            return (JellyException)cause;
        }
        if (cause instanceof InvocationTargetException) {
            return new JellyException(reason, ((InvocationTargetException)cause).getTargetException(), this.fileName, this.elementName, this.columnNumber, this.lineNumber);
        }
        return new JellyException(reason, cause, this.fileName, this.elementName, this.columnNumber, this.lineNumber);
    }

    protected void handleException(JellyTagException e) throws JellyTagException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caught exception: " + e), (Throwable)e);
        }
        this.applyLocation(e);
        throw e;
    }

    protected void handleException(JellyException e) throws JellyTagException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caught exception: " + e), (Throwable)e);
        }
        this.applyLocation(e);
        throw new JellyTagException(e);
    }

    protected void applyLocation(LocationAware locationAware) {
        if (locationAware.getLineNumber() == -1) {
            locationAware.setColumnNumber(this.columnNumber);
            locationAware.setLineNumber(this.lineNumber);
        }
        if (locationAware.getFileName() == null) {
            locationAware.setFileName(this.fileName);
        }
        if (locationAware.getElementName() == null) {
            locationAware.setElementName(this.elementName);
        }
    }

    protected void handleException(Exception e) throws JellyTagException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caught exception: " + e), (Throwable)e);
        }
        if (e instanceof LocationAware) {
            this.applyLocation((LocationAware)((Object)e));
        }
        if (e instanceof JellyException) {
            e.fillInStackTrace();
        }
        if (e instanceof InvocationTargetException) {
            throw new JellyTagException(((InvocationTargetException)e).getTargetException(), this.fileName, this.elementName, this.columnNumber, this.lineNumber);
        }
        throw new JellyTagException(e, this.fileName, this.elementName, this.columnNumber, this.lineNumber);
    }

    protected void handleException(Error e) throws Error, JellyTagException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caught exception: " + e), (Throwable)e);
        }
        if (e instanceof LocationAware) {
            this.applyLocation((LocationAware)((Object)e));
        }
        throw new JellyTagException(e, this.fileName, this.elementName, this.columnNumber, this.lineNumber);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

