/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MapTagSupport;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.BeanSource;
import org.apache.commons.jelly.tags.core.ArgTag;
import org.apache.commons.jelly.util.ClassLoaderUtils;

public class UseBeanTag
extends MapTagSupport
implements BeanSource {
    private Object bean;
    private Class defaultClass;
    private Set ignoreProperties;
    private boolean ignoreUnknownProperties = false;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$core$ArgTag;

    public UseBeanTag() {
    }

    public UseBeanTag(Class defaultClass) {
        this.defaultClass = defaultClass;
    }

    public Object getBean() {
        return this.bean;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        Map attributes = this.getAttributes();
        String var = (String)attributes.get("var");
        Object classObject = attributes.get("class");
        this.addIgnoreProperty("class");
        this.addIgnoreProperty("var");
        try {
            Class theClass = this.convertToClass(classObject);
            this.bean = this.newInstance(theClass, attributes, output);
            this.setBeanProperties(this.bean, attributes);
            this.invokeBody(output);
            this.processBean(var, this.bean);
        }
        catch (ClassNotFoundException e) {
            throw new JellyTagException(e);
        }
    }

    protected void setBean(Object bean) {
        this.bean = bean;
    }

    protected Class convertToClass(Object classObject) throws MissingAttributeException, ClassNotFoundException {
        if (classObject instanceof Class) {
            return (Class)classObject;
        }
        if (classObject == null) {
            Class theClass = this.getDefaultClass();
            if (theClass == null) {
                throw new MissingAttributeException("class");
            }
            return theClass;
        }
        String className = classObject.toString();
        return this.loadClass(className);
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtils.loadClass(className, this.getClass());
    }

    protected Object newInstance(Class theClass, Map attributes, XMLOutput output) throws JellyTagException {
        try {
            return theClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new JellyTagException(e.toString());
        }
        catch (InstantiationException e) {
            throw new JellyTagException(e.toString());
        }
    }

    protected void setBeanProperties(Object bean, Map attributes) throws JellyTagException {
        HashMap attrsToUse = new HashMap(attributes);
        attrsToUse.keySet().removeAll(this.getIgnorePropertySet());
        this.validateBeanProperties(bean, attrsToUse);
        try {
            BeanUtils.populate((Object)bean, attrsToUse);
        }
        catch (IllegalAccessException e) {
            throw new JellyTagException("could not set the properties of the bean", e);
        }
        catch (InvocationTargetException e) {
            throw new JellyTagException("could not set the properties of the bean", e);
        }
    }

    protected void validateBeanProperties(Object bean, Map attributes) throws JellyTagException {
        if (!this.isIgnoreUnknownProperties()) {
            Iterator i = attributes.keySet().iterator();
            while (i.hasNext()) {
                String attrName = (String)i.next();
                if (PropertyUtils.isWriteable((Object)bean, (String)attrName)) continue;
                throw new JellyTagException("No bean property found: " + attrName);
            }
        }
    }

    protected void processBean(String var, Object bean) throws JellyTagException {
        if (var != null) {
            this.context.setVariable(var, bean);
        } else {
            ArgTag parentArg = (ArgTag)this.findAncestorWithClass(class$org$apache$commons$jelly$tags$core$ArgTag == null ? (class$org$apache$commons$jelly$tags$core$ArgTag = UseBeanTag.class$("org.apache.commons.jelly.tags.core.ArgTag")) : class$org$apache$commons$jelly$tags$core$ArgTag);
            if (null != parentArg) {
                parentArg.setValue(bean);
            }
        }
    }

    protected Class getDefaultClass() {
        return this.defaultClass;
    }

    protected void addIgnoreProperty(String name) {
        this.getIgnorePropertySet().add(name);
    }

    protected Set getIgnorePropertySet() {
        if (this.ignoreProperties == null) {
            this.ignoreProperties = new HashSet();
        }
        return this.ignoreProperties;
    }

    public boolean isIgnoreUnknownProperties() {
        return this.ignoreUnknownProperties;
    }

    public void setIgnoreUnknownProperties(boolean ignoreUnknownProps) {
        this.ignoreUnknownProperties = ignoreUnknownProps;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

