package org.jvnet.hudson.ec2.launcher.gui;

import org.jvnet.hudson.ec2.launcher.Storage;
import org.jvnet.hudson.ec2.launcher.StorageList;
import com.xerox.amazonws.ec2.EC2Exception;
import org.jets3t.service.S3ServiceException;
import org.pietschy.wizard.InvalidStateException;

import javax.swing.*;
import javax.xml.bind.JAXBException;
import java.awt.*;

/**
 * Asks the user to select the Elastic Block Storage to run Hudson with.
 *
 * @author Kohsuke Kawaguchi
 */
public class SelectEBSPage extends Page {
    private JRadioButton runWithExistingDatasetRadioButton;
    private JRadioButton createANewDataRadioButton;
    private JList storageList;
    private JTextField storageSize;
    private JTextField storageName;
    private JPanel panel;

    private StorageList storages;

    public SelectEBSPage(WizardState state) {
        super(state);

        $$$setupUI$$$();

        storageList.setVisibleRowCount(5);
        add(panel);
    }

    @Override
    public void prepare() {
        storages = state.getStorageList();
        storageList.setModel(storages.asListModel());
        switch (storages.size()) {
        case 0:
            // disable the selection
            runWithExistingDatasetRadioButton.setEnabled(false);
            storageList.setEnabled(false);
            createANewDataRadioButton.setSelected(true);
            break;
        case 1:
            // select the sole instance
            storageList.setSelectedIndex(0);
            break;
        }

        new CompletionUpdater() {
            @Override
            public void update() {
                setComplete(
                        (runWithExistingDatasetRadioButton.isSelected() && !storageList.isSelectionEmpty()) ||
                                (createANewDataRadioButton.isSelected() && storageSize.getText().length() > 0 && storageSize.getText().length() > 0));
            }
        }.add(runWithExistingDatasetRadioButton).add(createANewDataRadioButton).add(storageList).add(storageSize).update();
    }

    @Override
    public void applyState() throws InvalidStateException {
        if (createANewDataRadioButton.isSelected()) {
            busyCursor();
            // create a new EBS
            int sz;
            try {
                sz = Integer.parseInt(storageSize.getText());
                if (sz < 1)
                    throw new InvalidStateException("Storage size is too small");
            } catch (NumberFormatException e) {
                throw new InvalidStateException(storageSize.getText() + " is not a valid number");
            }
            try {
                launcher.setStorage(storages.create(launcher, storageName.getText(), sz));
            } catch (EC2Exception e) {
                reportError("Failed to create Elastic Block Storage", e);
                throw new InvalidStateException();
            } catch (JAXBException e) {
                reportError("Failed to persist storage list", e);
                throw new InvalidStateException();
            } catch (S3ServiceException e) {
                reportError("Failed to persist storage list", e);
                throw new InvalidStateException();
            }
        } else {
            launcher.setStorage((Storage) storageList.getSelectedValue());
        }
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        runWithExistingDatasetRadioButton = new JRadioButton();
        runWithExistingDatasetRadioButton.setSelected(true);
        runWithExistingDatasetRadioButton.setText("Run with existing data storage");
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = GridBagConstraints.WEST;
        panel.add(runWithExistingDatasetRadioButton, gbc);
        final JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.weighty = 999.0;
        gbc.fill = GridBagConstraints.VERTICAL;
        panel.add(spacer1, gbc);
        createANewDataRadioButton = new JRadioButton();
        createANewDataRadioButton.setText("Create a new data storage");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = GridBagConstraints.WEST;
        panel.add(createANewDataRadioButton, gbc);
        final JLabel label1 = new JLabel();
        label1.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.ipadx = 32;
        panel.add(label1, gbc);
        final JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = GridBagConstraints.BOTH;
        panel.add(scrollPane1, gbc);
        storageList = new JList();
        storageList.setSelectionMode(0);
        scrollPane1.setViewportView(storageList);
        final JLabel label2 = new JLabel();
        label2.setText("name: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = GridBagConstraints.EAST;
        panel.add(label2, gbc);
        final JLabel label3 = new JLabel();
        label3.setText("size: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.anchor = GridBagConstraints.EAST;
        panel.add(label3, gbc);
        final JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.fill = GridBagConstraints.BOTH;
        panel.add(panel1, gbc);
        storageSize = new JTextField();
        storageSize.setColumns(4);
        storageSize.setHorizontalAlignment(4);
        storageSize.setText("");
        panel1.add(storageSize);
        final JLabel label4 = new JLabel();
        label4.setText("GB");
        panel1.add(label4);
        storageName = new JTextField();
        storageName.setColumns(20);
        storageName.setEditable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel.add(storageName, gbc);
        final JLabel label5 = new JLabel();
        label5.setText("(the size can be expanded later)");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.anchor = GridBagConstraints.WEST;
        panel.add(label5, gbc);
        final JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.weightx = 999.0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel.add(spacer2, gbc);
        ButtonGroup buttonGroup;
        buttonGroup = new ButtonGroup();
        buttonGroup.add(runWithExistingDatasetRadioButton);
        buttonGroup.add(createANewDataRadioButton);
    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return panel;
    }
}
