package org.jvnet.hudson.ec2.launcher.gui;

import org.jvnet.hudson.ec2.launcher.gui.CompletionUpdater;
import com.xerox.amazonws.ec2.EC2Exception;
import org.jets3t.service.S3ServiceException;
import org.pietschy.wizard.InvalidStateException;

import javax.swing.*;
import javax.xml.bind.JAXBException;
import java.awt.*;

/**
 * Asks for the login information.
 *
 * @author Kohsuke Kawaguchi
 */
public class StartPage extends Page {
    private JRadioButton loginToEC2AccountRadioButton;
    private JRadioButton createANewEC2RadioButton;
    private JTextField accessId;
    private JPasswordField secretKey;
    private JPanel panel;
    private JCheckBox rememberPassword;

    public StartPage(WizardState state) {
        super(state);
        add(panel);

        new CompletionUpdater() {
            @Override
            public void update() {
                accessId.setEnabled(loginToEC2AccountRadioButton.isSelected());
                secretKey.setEnabled(loginToEC2AccountRadioButton.isSelected());
                setComplete(loginToEC2AccountRadioButton.isSelected() && has(accessId) && has(secretKey));
            }
        }.add(loginToEC2AccountRadioButton).add(accessId).add(secretKey).update();

        accessId.setText(state.prefs.get(PREFKEY_ACCESSID, ""));
        String pwd = state.prefs.get(PREFKEY_SECRETKEY, "");
        secretKey.setText(pwd);
        rememberPassword.setSelected(pwd.length() > 0);
    }

    @Override
    public void applyState() throws InvalidStateException {
        try {
            busyCursor();
            String id = accessId.getText();
            if (id.length() != 20)
                throw new InvalidStateException("Incorrect access ID. Its length is supposed to be 20 chars");
            String password = new String(secretKey.getPassword());
            if (password.length() != 40)
                throw new InvalidStateException("Incorrect secret key. Its length is supposed to be 40 chars");
            state.setCredential(id, password);
            state.prefs.put(PREFKEY_ACCESSID, id);
            if (rememberPassword.isSelected())
                state.prefs.put(PREFKEY_SECRETKEY, password);
            else
                state.prefs.put(PREFKEY_SECRETKEY, "");
        } catch (EC2Exception e) {
            reportError("Operations on EC2 failed", e);
            throw new InvalidStateException();
        } catch (JAXBException e) {
            reportError("Failed to load storage information", e);
            throw new InvalidStateException();
        } catch (S3ServiceException e) {
            reportError("Operations on S3 failed", e);
            throw new InvalidStateException();
        } finally {
            restoreCursor();
        }
    }

    private static final String PREFKEY_ACCESSID = "accessId";
    private static final String PREFKEY_SECRETKEY = "secretKey";

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        loginToEC2AccountRadioButton = new JRadioButton();
        loginToEC2AccountRadioButton.setSelected(true);
        loginToEC2AccountRadioButton.setText("Login to EC2 account");
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = GridBagConstraints.WEST;
        panel.add(loginToEC2AccountRadioButton, gbc);
        createANewEC2RadioButton = new JRadioButton();
        createANewEC2RadioButton.setEnabled(false);
        createANewEC2RadioButton.setText("Create a new EC2 account");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = GridBagConstraints.WEST;
        panel.add(createANewEC2RadioButton, gbc);
        accessId = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel.add(accessId, gbc);
        final JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weighty = 99.0;
        gbc.fill = GridBagConstraints.VERTICAL;
        panel.add(spacer1, gbc);
        final JLabel label1 = new JLabel();
        label1.setText("Access Id: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.EAST;
        panel.add(label1, gbc);
        final JLabel label2 = new JLabel();
        label2.setText("Secret Key: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = GridBagConstraints.EAST;
        panel.add(label2, gbc);
        secretKey = new JPasswordField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel.add(secretKey, gbc);
        final JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 99.0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel.add(spacer2, gbc);
        final JLabel label3 = new JLabel();
        label3.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.ipadx = 32;
        panel.add(label3, gbc);
        rememberPassword = new JCheckBox();
        rememberPassword.setText("Remember the secret key");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = GridBagConstraints.WEST;
        panel.add(rememberPassword, gbc);
        ButtonGroup buttonGroup;
        buttonGroup = new ButtonGroup();
        buttonGroup.add(loginToEC2AccountRadioButton);
        buttonGroup.add(createANewEC2RadioButton);
    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return panel;
    }
}
