/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher;

import java.io.IOException;
import java.io.OutputStream;
import org.jvnet.hudson.ec2.launcher.FastPipedInputStream;

public class FastPipedOutputStream
extends OutputStream {
    FastPipedInputStream sink;

    public FastPipedOutputStream() {
    }

    public FastPipedOutputStream(FastPipedInputStream sink) throws IOException {
        this(sink, 65536);
    }

    public FastPipedOutputStream(FastPipedInputStream sink, int bufferSize) throws IOException {
        if (sink != null) {
            this.connect(sink);
            sink.buffer = new byte[bufferSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.sink == null) {
            throw new IOException("Unconnected pipe");
        }
        byte[] byArray = this.sink.buffer;
        synchronized (this.sink.buffer) {
            this.sink.closed = true;
            this.flush();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void connect(FastPipedInputStream sink) throws IOException {
        if (this.sink != null) {
            throw new IOException("Pipe already connected");
        }
        this.sink = sink;
        sink.source = this;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        byte[] byArray = this.sink.buffer;
        synchronized (this.sink.buffer) {
            this.sink.buffer.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sink == null) {
            throw new IOException("Unconnected pipe");
        }
        if (this.sink.closed) {
            throw new IOException("Broken pipe");
        }
        while (len > 0) {
            byte[] byArray = this.sink.buffer;
            // MONITORENTER : this.sink.buffer
            if (this.sink.writePosition == this.sink.readPosition && this.sink.writeLaps > this.sink.readLaps) {
                try {
                    this.sink.buffer.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e.getMessage());
                }
                continue;
            }
            int amount = Math.min(len, (this.sink.writePosition < this.sink.readPosition ? this.sink.readPosition : this.sink.buffer.length) - this.sink.writePosition);
            System.arraycopy(b, off, this.sink.buffer, this.sink.writePosition, amount);
            this.sink.writePosition += amount;
            if (this.sink.writePosition == this.sink.buffer.length) {
                this.sink.writePosition = 0;
                ++this.sink.writeLaps;
            }
            off += amount;
            len -= amount;
            this.sink.buffer.notifyAll();
            // MONITOREXIT : byArray
        }
    }
}

