/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jvnet.hudson.ec2.launcher.InstanceState;
import org.jvnet.hudson.ec2.launcher.OperatorErrorException;
import org.jvnet.hudson.ec2.launcher.PrivateKeyFile;
import org.jvnet.hudson.ec2.launcher.Storage;

public class Launcher {
    private Jec2 ec2;
    private Storage storage;
    private PrivateKeyFile privateKey;
    private String privateKeyName;
    private String accessId;
    private String secretKey;
    private ReservationDescription.Instance instance;

    public Jec2 getEc2() {
        return this.ec2;
    }

    public void setCredential(String accessId, String secretKey) throws EC2Exception {
        this.accessId = accessId;
        this.secretKey = secretKey;
        this.ec2 = new Jec2(accessId, secretKey);
        this.ec2.describeInstances(Collections.emptyList());
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setPrivateKey(File keyFile) throws IOException, EC2Exception, OperatorErrorException {
        if (!keyFile.exists()) {
            throw new OperatorErrorException("No such file exists: " + keyFile);
        }
        PrivateKeyFile pk = new PrivateKeyFile(keyFile);
        if (!pk.isPrivateKey()) {
            throw new OperatorErrorException("Not a valid RSA private key file: " + keyFile);
        }
        String fingerprint = pk.getFingerprint();
        for (KeyPairInfo k : this.ec2.describeKeyPairs(Collections.emptyList())) {
            if (!k.getKeyFingerprint().equalsIgnoreCase(fingerprint)) continue;
            this.privateKeyName = k.getKeyName();
            this.privateKey = pk;
            return;
        }
        throw new OperatorErrorException("This key is not registered in EC2. You probably didn't create this key with ec2-add-keypair");
    }

    public PrivateKeyFile getPrivateKey() {
        if (this.privateKey == null) {
            throw new IllegalStateException("private key is not set yet");
        }
        return this.privateKey;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public Storage getStorage() {
        if (this.storage == null) {
            throw new IllegalStateException("storage is not set yet");
        }
        return this.storage;
    }

    public ReservationDescription.Instance getInstance() {
        if (this.instance == null) {
            throw new IllegalStateException("instance is not set yet");
        }
        return this.instance;
    }

    public ReservationDescription.Instance start() throws EC2Exception, OperatorErrorException {
        LaunchConfiguration lc = new LaunchConfiguration("ami-7db75014");
        lc.setMinCount(1);
        lc.setMaxCount(1);
        lc.setSecurityGroup(Collections.emptyList());
        lc.setKeyName(this.privateKeyName);
        lc.setInstanceType(InstanceType.DEFAULT);
        lc.setAvailabilityZone(this.storage.getAvailabilityZone(this.ec2));
        ReservationDescription rd = this.ec2.runInstances(lc);
        this.instance = (ReservationDescription.Instance)rd.getInstances().get(0);
        return this.instance;
    }

    public InstanceState checkBootStatus(ReservationDescription.Instance inst) throws EC2Exception {
        List r = this.ec2.describeInstances(Collections.singletonList(inst.getInstanceId()));
        if (r.isEmpty()) {
            return InstanceState.TERMINATED;
        }
        List insts = ((ReservationDescription)r.get(0)).getInstances();
        if (insts.isEmpty()) {
            return InstanceState.TERMINATED;
        }
        return InstanceState.parse((ReservationDescription.Instance)insts.get(0));
    }
}

