/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.DigestInputStream;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;

class PrivateKeyFile {
    public final File file;

    public PrivateKeyFile(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFingerprint() throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        BufferedReader r = new BufferedReader(new FileReader(this.file));
        try {
            PEMReader pem = new PEMReader((Reader)r);
            PrivateKey key = ((KeyPair)pem.readObject()).getPrivate();
            String string = PrivateKeyFile.digest(key);
            return string;
        }
        finally {
            ((Reader)r).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrivateKey() throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.equals("-----BEGIN RSA PRIVATE KEY-----")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String digest(PrivateKey k) throws IOException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("SHA1");
            DigestInputStream in = new DigestInputStream(new ByteArrayInputStream(k.getEncoded()), md5);
            try {
                while (in.read(new byte[128]) > 0) {
                }
            }
            finally {
                in.close();
            }
            StringBuilder buf = new StringBuilder();
            char[] hex = Hex.encodeHex((byte[])md5.digest());
            for (int i = 0; i < hex.length; i += 2) {
                if (buf.length() > 0) {
                    buf.append(':');
                }
                buf.append(hex, i, 2);
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

