/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher;

import com.xerox.amazonws.ec2.AttachmentInfo;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.VolumeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.jvnet.hudson.ec2.launcher.OperatorErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
public class Storage {
    @XmlAttribute
    public final String name;
    @XmlAttribute
    public final List<String> volumes;

    public Storage(String name, String ... volumes) {
        this.name = name;
        this.volumes = Arrays.asList(volumes);
    }

    private Storage() {
        this.name = null;
        this.volumes = null;
    }

    public String toString() {
        return this.name;
    }

    public String getAvailabilityZone(Jec2 ec2) throws EC2Exception, OperatorErrorException {
        VolumeInfo ref = null;
        for (VolumeInfo vi : ec2.describeVolumes(this.volumes)) {
            if (ref == null) {
                ref = vi;
            }
            if (ref.getZone().equals(vi.getZone())) continue;
            throw new OperatorErrorException("EBS volume " + ref.getVolumeId() + " and " + vi.getVolumeId() + " are on different availability zones.");
        }
        return ref.getZone();
    }

    public List<String> attach(ReservationDescription.Instance inst, Jec2 ec2) throws EC2Exception, OperatorErrorException, InterruptedException {
        boolean attached;
        int device = 5;
        ArrayList<String> r = new ArrayList<String>();
        for (String id : this.volumes) {
            r.add("/dev/dsk/c3d" + device);
            ec2.attachVolume(id, inst.getInstanceId(), String.valueOf(device++));
        }
        int cnt = 0;
        block1: do {
            attached = true;
            ++cnt;
            Thread.sleep(1000L);
            for (VolumeInfo vi : ec2.describeVolumes(this.volumes)) {
                List ai = vi.getAttachmentInfo();
                if (ai == null || ai.size() == 0) {
                    if (cnt > 20) {
                        throw new OperatorErrorException("EBS volume " + vi.getVolumeId() + " appears to have failed to attach");
                    }
                    attached = false;
                    continue block1;
                }
                String st = ((AttachmentInfo)ai.get(0)).getStatus();
                if (st == null) {
                    st = "";
                }
                if (st.equals("attaching")) {
                    attached = false;
                    continue block1;
                }
                if (st.equals("attached")) continue;
                throw new OperatorErrorException("EBS volume " + vi.getVolumeId() + " reported its status as " + st);
            }
        } while (!attached);
        return r;
    }

    public boolean isAllVolumesPresent(List<VolumeInfo> infos) {
        block0: for (String vol : this.volumes) {
            for (VolumeInfo info : infos) {
                if (!info.getVolumeId().equals(vol)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }
}

