/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.VolumeInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jvnet.hudson.ec2.launcher.Launcher;
import org.jvnet.hudson.ec2.launcher.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
public class StorageList
implements Iterable<Storage> {
    @XmlElementRef
    private final List<Storage> storages = new ArrayList<Storage>();
    private final transient RestS3Service s3;
    private transient String accessId;
    private static final JAXBContext JAXB;
    private static final Logger LOGGER;

    public StorageList(String accessId, String secretKey) throws S3ServiceException, JAXBException, EC2Exception {
        this.s3 = new RestS3Service(new AWSCredentials(accessId, secretKey));
        this.accessId = accessId;
        S3Bucket b = this.s3.getBucket(this.getBucketName());
        if (b != null) {
            try {
                StorageList src = (StorageList)JAXB.createUnmarshaller().unmarshal(this.s3.getObject(b, "storages.xml").getDataInputStream());
                this.storages.addAll(src.storages);
            }
            catch (S3ServiceException e) {
                LOGGER.log(Level.INFO, "No storages.xml. Assuming there's no storage", e);
            }
        }
        Jec2 ec2 = new Jec2(accessId, secretKey);
        List volInfos = ec2.describeVolumes(Collections.emptyList());
        Iterator<Storage> itr = this.storages.iterator();
        while (itr.hasNext()) {
            Storage s = itr.next();
            if (s.isAllVolumesPresent(volInfos)) continue;
            itr.remove();
        }
    }

    private StorageList() {
        this.s3 = null;
    }

    @Override
    public Iterator<Storage> iterator() {
        return this.storages.iterator();
    }

    public int size() {
        return this.storages.size();
    }

    public Storage create(Launcher l, String name, int sizeInGB) throws EC2Exception, JAXBException, S3ServiceException {
        VolumeInfo v = l.getEc2().createVolume(String.valueOf(sizeInGB), null, "us-east-1b");
        Storage s = new Storage(name, v.getVolumeId());
        this.storages.add(s);
        this.save();
        return s;
    }

    public Storage get(String name) {
        for (Storage s : this.storages) {
            if (!s.name.equals(name)) continue;
            return s;
        }
        return null;
    }

    private void save() throws S3ServiceException, JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXB.createMarshaller().marshal((Object)this, (OutputStream)baos);
        S3Bucket b = this.s3.getBucket(this.getBucketName());
        if (b == null) {
            b = this.s3.createBucket(this.getBucketName());
        }
        S3Object s3o = new S3Object(b, "storages.xml");
        s3o.setDataInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        s3o.setContentType("application/xml; charset=UTF-8");
        this.s3.putObject(b, s3o);
    }

    private String getBucketName() {
        return "hudson-" + this.accessId;
    }

    public ListModel asListModel() {
        return new ListModel(){

            public int getSize() {
                return StorageList.this.storages.size();
            }

            public Object getElementAt(int index) {
                return StorageList.this.storages.get(index);
            }

            public void addListDataListener(ListDataListener l) {
            }

            public void removeListDataListener(ListDataListener l) {
            }
        };
    }

    static {
        try {
            JAXB = JAXBContext.newInstance((Class[])new Class[]{StorageList.class});
        }
        catch (JAXBException e) {
            throw new AssertionError((Object)e);
        }
        LOGGER = Logger.getLogger(StorageList.class.getName());
    }
}

