/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jvnet.hudson.ec2.launcher.Booter;
import org.jvnet.hudson.ec2.launcher.FastPipedInputStream;
import org.jvnet.hudson.ec2.launcher.FastPipedOutputStream;
import org.jvnet.hudson.ec2.launcher.gui.Page;
import org.jvnet.hudson.ec2.launcher.gui.WizardState;

public class BootPage
extends Page {
    private JTextArea console;
    private JPanel panel;
    private JLabel status;
    private JProgressBar progressBar;
    private JScrollPane scrollPane;
    private Booter thread;

    public BootPage(WizardState state) {
        super(state);
        this.$$$setupUI$$$();
        this.add(this.panel);
    }

    public void prepare() {
        FastPipedInputStream in;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.setBusy(true);
        this.console.setText("");
        this.progressBar.setIndeterminate(true);
        FastPipedOutputStream out = new FastPipedOutputStream();
        try {
            in = new FastPipedInputStream(out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        new Thread(){
            final BufferedReader reader;
            {
                this.reader = new BufferedReader(new InputStreamReader(in));
            }

            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        final String text = line;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                BootPage.this.console.append(text + '\n');
                                BootPage.this.scrollDown();
                            }
                        });
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }.start();
        this.thread = new Booter(this, out){

            protected void reportStatus(final String msg) {
                super.reportStatus(msg);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BootPage.this.status.setText(msg);
                    }
                });
            }

            protected void reportError(final String msg) {
                super.reportError(msg);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BootPage.this.status.setText(msg);
                    }
                });
            }

            protected void onEnd() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BootPage.this.progressBar.setIndeterminate(false);
                        BootPage.this.progressBar.setValue(100);
                    }
                });
            }
        };
        this.thread.start();
    }

    private void scrollDown() {
        int pos = this.console.getDocument().getEndPosition().getOffset();
        this.console.getCaret().setDot(pos);
        this.console.requestFocus();
    }

    public void abortBusy() {
        this.thread.interrupt();
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), null));
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 1;
        this.panel.add((Component)this.scrollPane, gbc);
        this.console = new JTextArea();
        this.console.setColumns(40);
        this.console.setRows(10);
        this.scrollPane.setViewportView(this.console);
        this.status = new JLabel();
        this.status.setText("Starting...");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.panel.add((Component)this.status, gbc);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.panel.add((Component)this.progressBar, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 999.0;
        gbc.fill = 2;
        this.panel.add((Component)spacer1, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weighty = 999.0;
        gbc.fill = 3;
        this.panel.add((Component)spacer2, gbc);
        JLabel label1 = new JLabel();
        label1.setText(" ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        this.panel.add((Component)label1, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

