/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher.gui;

import com.xerox.amazonws.ec2.EC2Exception;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.xml.bind.JAXBException;
import org.jets3t.service.S3ServiceException;
import org.jvnet.hudson.ec2.launcher.Storage;
import org.jvnet.hudson.ec2.launcher.StorageList;
import org.jvnet.hudson.ec2.launcher.gui.CompletionUpdater;
import org.jvnet.hudson.ec2.launcher.gui.Page;
import org.jvnet.hudson.ec2.launcher.gui.WizardState;
import org.pietschy.wizard.InvalidStateException;

public class SelectEBSPage
extends Page {
    private JRadioButton runWithExistingDatasetRadioButton;
    private JRadioButton createANewDataRadioButton;
    private JList storageList;
    private JTextField storageSize;
    private JTextField storageName;
    private JPanel panel;
    private StorageList storages;

    public SelectEBSPage(WizardState state) {
        super(state);
        this.$$$setupUI$$$();
        this.storageList.setVisibleRowCount(5);
        this.add(this.panel);
    }

    public void prepare() {
        this.storages = this.state.getStorageList();
        this.storageList.setModel(this.storages.asListModel());
        switch (this.storages.size()) {
            case 0: {
                this.runWithExistingDatasetRadioButton.setEnabled(false);
                this.storageList.setEnabled(false);
                this.createANewDataRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.storageList.setSelectedIndex(0);
            }
        }
        new CompletionUpdater(){

            public void update() {
                SelectEBSPage.this.setComplete(SelectEBSPage.this.runWithExistingDatasetRadioButton.isSelected() && !SelectEBSPage.this.storageList.isSelectionEmpty() || SelectEBSPage.this.createANewDataRadioButton.isSelected() && SelectEBSPage.this.storageSize.getText().length() > 0 && SelectEBSPage.this.storageSize.getText().length() > 0);
            }
        }.add(this.runWithExistingDatasetRadioButton).add(this.createANewDataRadioButton).add(this.storageList).add(this.storageSize).update();
    }

    public void applyState() throws InvalidStateException {
        if (this.createANewDataRadioButton.isSelected()) {
            int sz;
            this.busyCursor();
            try {
                sz = Integer.parseInt(this.storageSize.getText());
                if (sz < 1) {
                    throw new InvalidStateException("Storage size is too small");
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidStateException(this.storageSize.getText() + " is not a valid number");
            }
            try {
                this.launcher.setStorage(this.storages.create(this.launcher, this.storageName.getText(), sz));
            }
            catch (EC2Exception e) {
                this.reportError("Failed to create Elastic Block Storage", e);
                throw new InvalidStateException();
            }
            catch (JAXBException e) {
                this.reportError("Failed to persist storage list", e);
                throw new InvalidStateException();
            }
            catch (S3ServiceException e) {
                this.reportError("Failed to persist storage list", e);
                throw new InvalidStateException();
            }
        }
        this.launcher.setStorage((Storage)this.storageList.getSelectedValue());
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.runWithExistingDatasetRadioButton = new JRadioButton();
        this.runWithExistingDatasetRadioButton.setSelected(true);
        this.runWithExistingDatasetRadioButton.setText("Run with existing data storage");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.panel.add((Component)this.runWithExistingDatasetRadioButton, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.weighty = 999.0;
        gbc.fill = 3;
        this.panel.add((Component)spacer1, gbc);
        this.createANewDataRadioButton = new JRadioButton();
        this.createANewDataRadioButton.setText("Create a new data storage");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.panel.add((Component)this.createANewDataRadioButton, gbc);
        JLabel label1 = new JLabel();
        label1.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.ipadx = 32;
        this.panel.add((Component)label1, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        this.panel.add((Component)scrollPane1, gbc);
        this.storageList = new JList();
        this.storageList.setSelectionMode(0);
        scrollPane1.setViewportView(this.storageList);
        JLabel label2 = new JLabel();
        label2.setText("name: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 13;
        this.panel.add((Component)label2, gbc);
        JLabel label3 = new JLabel();
        label3.setText("size: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.anchor = 13;
        this.panel.add((Component)label3, gbc);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.fill = 1;
        this.panel.add((Component)panel1, gbc);
        this.storageSize = new JTextField();
        this.storageSize.setColumns(4);
        this.storageSize.setHorizontalAlignment(4);
        this.storageSize.setText("");
        panel1.add(this.storageSize);
        JLabel label4 = new JLabel();
        label4.setText("GB");
        panel1.add(label4);
        this.storageName = new JTextField();
        this.storageName.setColumns(20);
        this.storageName.setEditable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.storageName, gbc);
        JLabel label5 = new JLabel();
        label5.setText("(the size can be expanded later)");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.anchor = 17;
        this.panel.add((Component)label5, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.weightx = 999.0;
        gbc.fill = 2;
        this.panel.add((Component)spacer2, gbc);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.runWithExistingDatasetRadioButton);
        buttonGroup.add(this.createANewDataRadioButton);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

