/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.ec2.launcher.gui;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.KeyPairInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.io.FileUtils;
import org.jvnet.hudson.ec2.launcher.OperatorErrorException;
import org.jvnet.hudson.ec2.launcher.gui.CompletionUpdater;
import org.jvnet.hudson.ec2.launcher.gui.Page;
import org.jvnet.hudson.ec2.launcher.gui.WizardState;
import org.pietschy.wizard.InvalidStateException;

public class SelectKeyPage
extends Page {
    private JRadioButton iAlreadyHaveARadioButton;
    private JRadioButton generateANewKeypairRadioButton;
    private JTextField loadKeyFile;
    private JButton selectExistingKey;
    private JTextField saveKeyFile;
    private JButton selectNewKey;
    private JTextField keyName;
    private JPanel panel;
    private static final String PREFKEY_PRIVATEKEY = "privateKeyFile";

    public SelectKeyPage(WizardState state) {
        super(state);
        this.$$$setupUI$$$();
        this.add(this.panel);
        new CompletionUpdater(){

            public void update() {
                boolean loadMode = SelectKeyPage.this.isLoadMode();
                SelectKeyPage.this.selectExistingKey.setEnabled(loadMode);
                SelectKeyPage.this.loadKeyFile.setEnabled(loadMode);
                SelectKeyPage.this.saveKeyFile.setEnabled(!loadMode);
                SelectKeyPage.this.selectNewKey.setEnabled(!loadMode);
                SelectKeyPage.this.keyName.setEnabled(!loadMode);
                if (loadMode) {
                    SelectKeyPage.this.setComplete(this.has(SelectKeyPage.this.loadKeyFile));
                } else {
                    SelectKeyPage.this.setComplete(this.has(SelectKeyPage.this.saveKeyFile) && this.has(SelectKeyPage.this.keyName));
                }
            }
        }.add(this.iAlreadyHaveARadioButton).add(this.generateANewKeypairRadioButton).add(this.loadKeyFile).add(this.saveKeyFile).add(this.keyName).update();
        this.selectExistingKey.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog((Component)((Object)SelectKeyPage.this)) == 0) {
                    SelectKeyPage.this.loadKeyFile.setText(fc.getSelectedFile().getPath());
                }
            }
        });
        this.selectNewKey.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showSaveDialog((Component)((Object)SelectKeyPage.this)) == 0) {
                    SelectKeyPage.this.saveKeyFile.setText(fc.getSelectedFile().getPath());
                }
            }
        });
        this.loadKeyFile.setText(state.prefs.get(PREFKEY_PRIVATEKEY, ""));
    }

    private boolean isLoadMode() {
        return this.iAlreadyHaveARadioButton.isSelected();
    }

    public void applyState() throws InvalidStateException {
        try {
            File f;
            this.busyCursor();
            if (this.isLoadMode()) {
                f = new File(this.loadKeyFile.getText());
                this.launcher.setPrivateKey(f);
            } else {
                KeyPairInfo kp = this.launcher.getEc2().createKeyPair(this.keyName.getText());
                f = new File(this.saveKeyFile.getText());
                FileUtils.writeStringToFile((File)f, (String)kp.getKeyMaterial());
                this.launcher.setPrivateKey(f);
            }
            this.state.prefs.put(PREFKEY_PRIVATEKEY, f.getPath());
        }
        catch (EC2Exception e) {
            this.reportError("Operations on EC2 failed", e);
            throw new InvalidStateException();
        }
        catch (IOException e) {
            this.reportError("Operations on EC2 failed", e);
            throw new InvalidStateException();
        }
        catch (OperatorErrorException e) {
            throw new InvalidStateException(e.getMessage());
        }
        finally {
            this.restoreCursor();
        }
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.iAlreadyHaveARadioButton = new JRadioButton();
        this.iAlreadyHaveARadioButton.setSelected(true);
        this.iAlreadyHaveARadioButton.setText("I already have a keypair for EC2");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.panel.add((Component)this.iAlreadyHaveARadioButton, gbc);
        this.generateANewKeypairRadioButton = new JRadioButton();
        this.generateANewKeypairRadioButton.setText("Generate a new keypair for EC2");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.panel.add((Component)this.generateANewKeypairRadioButton, gbc);
        JLabel label1 = new JLabel();
        label1.setText("Private key file: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 13;
        this.panel.add((Component)label1, gbc);
        this.loadKeyFile = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.loadKeyFile, gbc);
        this.selectExistingKey = new JButton();
        this.selectExistingKey.setText("...");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.panel.add((Component)this.selectExistingKey, gbc);
        this.saveKeyFile = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.saveKeyFile, gbc);
        this.selectNewKey = new JButton();
        this.selectNewKey.setText("...");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.fill = 2;
        this.panel.add((Component)this.selectNewKey, gbc);
        JLabel label2 = new JLabel();
        label2.setText("Save private key to: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 13;
        this.panel.add((Component)label2, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weighty = 999.0;
        gbc.fill = 3;
        this.panel.add((Component)spacer1, gbc);
        JLabel label3 = new JLabel();
        label3.setText("Key name: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 13;
        this.panel.add((Component)label3, gbc);
        this.keyName = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.keyName, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.weightx = 999.0;
        gbc.fill = 2;
        this.panel.add((Component)spacer2, gbc);
        JLabel label4 = new JLabel();
        label4.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.ipadx = 32;
        this.panel.add((Component)label4, gbc);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.iAlreadyHaveARadioButton);
        buttonGroup.add(this.generateANewKeypairRadioButton);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

